package dev.mariany.genesisframework.age;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mariany.genesisframework.advancement.criterion.CompleteTrialSpawnerCriteria;
import dev.mariany.genesisframework.advancement.criterion.ObtainAdvancementCriterion;
import dev.mariany.genesisframework.stat.GFStats;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2080;
import net.minecraft.class_2096;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3468;
import net.minecraft.class_3735;
import net.minecraft.class_4553;
import net.minecraft.class_5258;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.predicate.entity.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;

public record Age(
        List<class_1856> items,
        List<class_5321<class_1937>> dimensions,
        Optional<class_2960> parent,
        boolean requiresParent,
        Map<String, class_175<?>> criteria,
        class_8782 requirements,
        AgeDisplay display
) {
    private static final Codec<Map<String, class_175<?>>> CRITERIA_CODEC = Codec.unboundedMap(Codec.STRING, class_175.field_47188);
    public static final Codec<Age> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                            class_1856.field_46095.listOf().optionalFieldOf("items", List.of()).forGetter(Age::items),
                            class_5321.method_39154(class_7924.field_41223).listOf().optionalFieldOf("dimensions", List.of())
                                    .forGetter(Age::dimensions),
                            class_2960.field_25139.optionalFieldOf("parent").forGetter(Age::parent),
                            Codec.BOOL.optionalFieldOf("requires_parent", true)
                                    .forGetter(Age::requiresParent),
                            CRITERIA_CODEC.optionalFieldOf("criteria", new HashMap<>()).forGetter(Age::criteria),
                            class_8782.field_47184.optionalFieldOf("requirements", class_8782.field_46084)
                                    .forGetter(Age::requirements),
                            AgeDisplay.CODEC.fieldOf("display").forGetter(Age::display)
                    )
                    .apply(instance, Age::new)
    );

    @SuppressWarnings("unused")
    public static class Builder {
        private final List<class_1856> items = new ArrayList<>();
        private final List<class_5321<class_1937>> dimensions = new ArrayList<>();
        @Nullable
        private class_2960 parent = null;
        private boolean requiresParent = true;
        private final Map<String, class_175<?>> criteria = new HashMap<>();
        private class_8782 requirements = class_8782.field_46084;
        private AgeDisplay display;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder itemUnlocks(class_1856 ingredient) {
            this.items.add(ingredient);
            return this;
        }

        public Builder itemUnlocks(List<class_1856> ingredients) {
            this.items.clear();
            this.items.addAll(ingredients);
            return this;
        }

        public Builder dimensionUnlocks(class_5321<class_1937> worldRegistryKey) {
            this.dimensions.add(worldRegistryKey);
            return this;
        }

        public Builder dimensionUnlocks(List<class_5321<class_1937>> worldRegistryKeys) {
            this.dimensions.clear();
            this.dimensions.addAll(worldRegistryKeys);
            return this;
        }

        public Builder parent(class_2960 parent) {
            this.parent = parent;
            return this;
        }

        public Builder parentOptional() {
            this.requiresParent = false;
            return this;
        }

        public Builder requirements(class_8782 advancementRequirements) {
            this.requirements = advancementRequirements;
            return this;
        }

        public Builder criterion(String name, class_175<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        public Builder requireAge(class_2960 id) {
            Optional<String> categoryOpt = AgeEntry.getCategory(id);
            Optional<String> subpathOpt = AgeEntry.getSubPath(id);

            String name = subpathOpt.map(
                    subpath -> categoryOpt
                            .map(category -> "has_" + subpath + "_" + category + "_age")
                            .orElse("has_" + subpath + "_age")
            ).orElse("has_age");

            return criterion(name, ObtainAdvancementCriterion.Conditions.create(AgeEntry.getAdvancementId(id)));
        }

        public Builder requireKill(
                class_7225.class_7226<class_1299<?>> entityLookup,
                class_1299<?> entityType,
                int atLeast
        ) {
            return criterion("killed_" + atLeast + class_1299.method_5890(entityType).method_12832(),
                    class_2080.class_2083.method_9001(
                            class_2048.class_2049.method_8916().method_8921(entityLookup, entityType),
                            class_2022.class_2023.method_8855().method_35131(
                                    class_2048.class_2049.method_8916().method_43094(
                                            class_4553.class_4557.method_35310().method_35311(
                                                    class_3468.field_15403,
                                                    entityType.method_40124(),
                                                    class_2096.class_2100.method_9053(atLeast - 1)).method_22507()
                                    )
                            )
                    )
            );
        }

        public Builder requireKillHostiles(int atLeast) {
            return criterion("killed_" + atLeast + "_hostiles",
                    class_174.field_1187.method_53699(
                            class_2135.class_2137.method_53788(
                                    class_2048.class_2049.method_8916().method_43094(
                                            class_4553.class_4557.method_35310().method_35311(
                                                    class_3468.field_15419,
                                                    GFStats.HOSTILE_KILLS,
                                                    class_2096.class_2100.method_9053(atLeast)
                                            ).method_22507()
                                    )
                            ).comp_1924()
                    )
            );
        }

        public Builder requireTrialWearing(
                class_7225.class_7226<class_1792> itemLookup,
                boolean ominous,
                class_1792 head,
                class_1792 chest,
                class_1792 legs,
                class_1792 feet
        ) {
            List<String> requirements = new ArrayList<>();

            for (class_1304 slot : class_1304.values()) {
                @Nullable class_3735 entityEquipmentPredicate = switch (slot) {
                    case field_6169 -> class_3735.class_5278.method_27965().method_27966(class_2073.class_2074.method_8973()
                            .method_8977(itemLookup, head)
                    ).method_27967();
                    case field_6174 -> class_3735.class_5278.method_27965().method_27968(class_2073.class_2074.method_8973()
                            .method_8977(itemLookup, chest)
                    ).method_27967();
                    case field_6172 -> class_3735.class_5278.method_27965().method_27969(class_2073.class_2074.method_8973()
                            .method_8977(itemLookup, legs)
                    ).method_27967();
                    case field_6166 -> class_3735.class_5278.method_27965().method_27970(class_2073.class_2074.method_8973()
                            .method_8977(itemLookup, feet)
                    ).method_27967();
                    default -> null;
                };

                if (entityEquipmentPredicate != null) {
                    String name = "trial_completed_with_" + slot.method_15434();

                    criterion(name, CompleteTrialSpawnerCriteria.Conditions.create(
                                    class_2048.method_51704(
                                            class_2048.class_2049.method_8916().method_16227(entityEquipmentPredicate).method_8920()
                                    ),
                                    ominous
                            )
                    );

                    requirements.add(name);
                }
            }

            this.requirements = class_8782.method_53674(requirements);

            return this;
        }

        public Builder requireTimePlayed(int ticks) {
            class_5258 predicate = class_2048.method_51704(
                    class_2048.class_2049.method_8916().method_43094(
                            class_4553.class_4557.method_35310().method_35311(
                                    class_3468.field_15419,
                                    class_7923.field_41183.method_46747(
                                            class_5321.method_29179(class_7924.field_41263, class_3468.field_15417)
                                    ),
                                    class_2096.class_2100.method_9053(ticks)).method_22507()
                    ).method_8920()
            );

            return criterion("time_played", class_174.field_1187.method_53699(
                            new class_2135.class_2137(Optional.of(predicate))
                    )
            );
        }

        public Builder display(AgeDisplay display) {
            this.display = display;
            return this;
        }

        public Builder display(class_1792 icon, class_2561 title, class_2561 description) {
            this.display = new AgeDisplay(icon.method_7854(), title, description);
            return this;
        }

        public AgeEntry build(class_2960 id) {
            return new AgeEntry(id, new Age(
                    this.items,
                    this.dimensions,
                    Optional.ofNullable(this.parent),
                    this.requiresParent,
                    this.criteria,
                    this.requirements,
                    this.display
            ));
        }

        public AgeEntry build(Consumer<AgeEntry> exporter, class_2960 id) {
            AgeEntry ageEntry = this.build(id);
            exporter.accept(ageEntry);
            return ageEntry;
        }
    }
}
