package dev.mariany.genesisframework.age;

import com.google.common.collect.ImmutableMap;
import dev.mariany.genesisframework.registry.GFRegistryKeys;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7225;

public class AgeDataLoader extends class_4309<Age> {
    public AgeDataLoader(class_7225.class_7874 registries) {
        super(registries, Age.CODEC, GFRegistryKeys.AGE);
    }

    @Override
    protected void apply(Map<class_2960, Age> map, class_3300 manager, class_3695 profiler) {
        AgeManager ageManager = AgeManager.getInstance();
        ageManager.clear();

        ImmutableMap.Builder<class_2960, AgeEntry> builder = ImmutableMap.builder();

        map.forEach((id, age) -> builder.put(id, new AgeEntry(id, age)));

        builder.buildOrThrow().values().forEach(ageManager::add);
    }
}
