package dev.mariany.genesisframework.age;

import dev.mariany.genesisframework.GenesisFramework;
import net.minecraft.advancement.*;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AgeEntry {
    public static final String ADVANCEMENT_PREFIX = "age/";
    public static final class_2960 ROOT_ADVANCEMENT_ID = GenesisFramework.id(ADVANCEMENT_PREFIX + "root");

    private final class_2960 id;
    private final Age age;
    private final class_8779 advancementEntry;

    public AgeEntry(class_2960 id, Age age) {
        this.id = id;
        this.age = age;
        this.advancementEntry = createAdvancementEntry(id, age);
    }

    private class_8779 createAdvancementEntry(class_2960 id, Age age) {
        return new class_8779(getAdvancementId(this), createAdvancement(id, age));
    }

    public static class_161 createAdvancement(class_2960 id, Age age) {
        class_2960 parent = age.parent()
                .map(AgeEntry::getAdvancementId)
                .orElse(AgeEntry.ROOT_ADVANCEMENT_ID);

        boolean alert = true;

        Map<String, class_175<?>> advancementCriteria = new HashMap<>(age.criteria());

        if (advancementCriteria.isEmpty()) {
            advancementCriteria.put("root", new class_175<>(class_174.field_1187, class_2135.class_2137.method_49195().comp_1924()));
            alert = false;
        }

        class_8782 requirements = age.requirements().method_53677() ?
                class_8782.method_53668(advancementCriteria.keySet()) :
                age.requirements();

        return new class_161(
                Optional.of(parent),
                Optional.of(createAdvancementDisplay(id, age, alert)),
                class_170.field_1167,
                advancementCriteria,
                requirements,
                false
        );
    }

    private static class_185 createAdvancementDisplay(class_2960 id, Age age, boolean alert) {
        AgeDisplay ageDisplay = age.display();

        class_5250 title = getCategory(id)
                .map(category -> class_2561.method_43471("age." + id.method_12836() + ".category." + category)
                        .method_10852(class_2561.method_43470(": "))
                        .method_10852(ageDisplay.title())
                        .method_10852(class_2561.method_43470(" "))
                        .method_10852(class_2561.method_43471("age.genesisframework.age")))
                .orElseGet(() -> class_2561.method_43469("age.genesisframework.title",
                        ageDisplay.title(),
                        class_2561.method_43471("age.genesisframework.age")));

        class_189 frame = age.requiresParent() ? class_189.field_1249 : class_189.field_1250;

        return new class_185(
                ageDisplay.icon(),
                title,
                ageDisplay.description(),
                Optional.empty(),
                frame,
                alert,
                alert,
                false
        );
    }

    public static Optional<String> getCategory(class_2960 id) {
        String path = id.method_12832();
        int index = path.indexOf('/');

        if (index >= 0) {
            return Optional.of(path.substring(0, index));
        }

        return Optional.empty();
    }

    public static Optional<String> getSubPath(class_2960 id) {
        String path = id.method_12832();
        int index = path.indexOf('/');

        if (index >= 0 && index + 1 < path.length()) {
            return Optional.of(path.substring(index + 1));
        }

        return Optional.empty();
    }


    public static class_2960 getAdvancementId(AgeEntry ageEntry) {
        return getAdvancementId(ageEntry.getId());
    }

    public static class_2960 getAdvancementId(class_2960 id) {
        return id.method_45138(ADVANCEMENT_PREFIX);
    }

    public class_2960 getId() {
        return this.id;
    }

    public Age getAge() {
        return this.age;
    }

    public class_8779 getAdvancementEntry() {
        return this.advancementEntry;
    }

    public boolean isDone(class_3222 player) {
        return player.method_14236().method_12882(this.advancementEntry).method_740();
    }

    public Optional<class_2960> getParentAdvancementId() {
        return this.advancementEntry.comp_1920().comp_1912();
    }
}
