package dev.mariany.genesisframework.age;

import dev.mariany.genesisframework.packet.clientbound.NotifyAgeLockedPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;

public class AgeLockNotifier {
    public static void notifyAgeLocked(String locked, Age age, class_3222 serverPlayer) {
        notifyAgeLocked(locked, age, false, serverPlayer);
    }

    public static void notifyAgeLockedClick(String locked, Age age, class_3222 serverPlayer) {
        notifyAgeLocked(locked, age, true, serverPlayer);
    }

    private static void notifyAgeLocked(String locked, Age age, boolean clickInteraction, class_3222 serverPlayer) {
        ServerPlayNetworking.send(serverPlayer, new NotifyAgeLockedPayload(locked, age.display().title().getString(), clickInteraction));
    }
}
