package dev.mariany.genesisframework.age;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.*;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8779;

public class AgeManager {
    private static final AgeManager INSTANCE = new AgeManager();

    private final Map<class_2960, AgeEntry> ages = new Object2ObjectOpenHashMap<>();

    public static AgeManager getInstance() {
        return INSTANCE;
    }

    public boolean isAgeGuarded(class_1935 item) {
        return this.ages.values()
                .stream()
                .anyMatch(
                        ageEntry -> ageEntry.getAge().items()
                                .stream()
                                .anyMatch(ingredient -> ingredient.method_8093(item.method_8389().method_7854()))
                );
    }

    public boolean isUnlocked(class_3222 player, class_5321<class_1937> worldRegistryKey) {
        return allUnlocked(player, getRequiredAges(worldRegistryKey));
    }

    public boolean isUnlocked(class_3222 player, class_2248 block) {
        return isUnlocked(player, block.method_8389().method_7854());
    }

    public boolean isUnlocked(class_3222 player, class_1799 stack) {
        return allUnlocked(player, getRequiredAges(stack));
    }

    public boolean allUnlocked(class_3222 player, Collection<AgeEntry> ages) {
        if (player.method_68878()) {
            return true;
        }

        if (ages.isEmpty()) {
            return true;
        }

        return ages.stream().allMatch(placedAge -> isDoneRecursively(placedAge, player));
    }

    public boolean isDoneRecursively(AgeEntry ageEntry, class_3222 player) {
        if (!ageEntry.getAge().requiresParent()) {
            return ageEntry.isDone(player);
        }

        while (ageEntry.isDone(player)) {
            Optional<class_2960> parentId = ageEntry.getAge().parent();

            if (parentId.isPresent()) {
                AgeEntry parentEntry = this.ages.get(parentId.get());

                if (parentEntry != null) {
                    ageEntry = parentEntry;
                    continue;
                }
            }

            return true;
        }

        return false;
    }

    public List<AgeEntry> getRequiredAges(class_1799 stack) {
        List<AgeEntry> requiredAges = new ArrayList<>();

        for (AgeEntry placedAge : this.ages.values()) {
            List<class_1856> itemUnlocks = placedAge.getAge().items();

            for (class_1856 ingredient : itemUnlocks) {
                if (ingredient.method_8093(stack)) {
                    requiredAges.add(placedAge);
                    break;
                }
            }
        }

        return requiredAges;
    }

    public List<AgeEntry> getRequiredAges(class_5321<class_1937> worldRegistryKey) {
        List<AgeEntry> requiredAges = new ArrayList<>();

        for (AgeEntry placedAge : this.ages.values()) {
            List<class_5321<class_1937>> dimensions = placedAge.getAge().dimensions();

            for (class_5321<class_1937> dimension : dimensions) {
                if (worldRegistryKey.method_29177().equals(dimension.method_29177())) {
                    requiredAges.add(placedAge);
                    break;
                }
            }
        }

        return requiredAges;
    }

    public Optional<AgeEntry> find(class_8779 advancementEntry) {
        return ages.values().stream().filter(
                ageEntry -> ageEntry.getAdvancementEntry().comp_1919().equals(advancementEntry.comp_1919())
        ).findAny();
    }

    public Optional<AgeEntry> find(Age age) {
        return ages.values().stream().filter(
                ageEntry -> ageEntry.getAge().equals(age)
        ).findAny();
    }

    public Optional<AgeEntry> get(class_2960 id) {
        return Optional.ofNullable(this.ages.get(id));
    }

    public Collection<AgeEntry> getAges() {
        return this.ages.values();
    }

    public List<class_1856> getLockedItems(class_3222 player) {
        return getAges()
                .stream()
                .filter(ageEntry -> !ageEntry.isDone(player))
                .flatMap(ageEntry -> ageEntry.getAge().items().stream())
                .toList();
    }

    protected void add(AgeEntry age) {
        this.ages.put(age.getId(), age);
    }

    protected void clear() {
        this.ages.clear();
    }
}
