package dev.mariany.genesisframework.age;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mariany.genesisframework.GenesisFramework;
import dev.mariany.genesisframework.advancement.AdvancementHelper;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Collectors;

public class AgeShareManager extends class_18 {
    private static final class_10741<AgeShareManager> STATE_TYPE = new class_10741<>(
            "ages",
            context -> new AgeShareManager(),
            context -> Packed.CODEC.xmap(AgeShareManager::new, AgeShareManager::pack),
            null
    );

    private final Set<class_2960> globalAges = new HashSet<>();
    private final Map<String, Set<class_2960>> teamAges = new HashMap<>();

    public AgeShareManager() {
        this.method_80();
    }

    public AgeShareManager(Packed packed) {
        this.unpack(packed);
    }

    public static AgeShareManager getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_30002().method_17983();

        AgeShareManager state = persistentStateManager.method_17924(STATE_TYPE);

        state.method_80();

        return state;
    }

    public int clear(boolean global) {
        int cleared;

        if (global) {
            cleared = this.globalAges.size();
            this.globalAges.clear();
        } else {
            cleared = this.teamAges.values().stream()
                    .mapToInt(Set::size)
                    .sum();

            this.teamAges.clear();
        }

        this.method_80();

        return cleared;
    }

    public void applySharedAges(class_3222 serverPlayer) {
        AgeManager ageManager = AgeManager.getInstance();
        class_268 team = serverPlayer.method_5781();
        Set<class_2960> agesToApply = new HashSet<>(this.globalAges);

        if (team != null) {
            Set<class_2960> teamAges = this.teamAges.getOrDefault(team.method_1197(), new HashSet<>());
            agesToApply.addAll(teamAges);
        }

        for (class_2960 ageId : agesToApply) {
            ageManager.get(ageId).ifPresent(ageEntry -> progressPlayerToAge(serverPlayer, ageEntry));
        }
    }

    private static List<class_3222> getSharingPlayers(MinecraftServer server) {
        return getSharingPlayers(server, null);
    }

    private static List<class_3222> getSharingPlayers(MinecraftServer server, @Nullable class_268 team) {
        if (team != null) {
            class_3324 playerManager = server.method_3760();
            List<class_3222> players = playerManager.method_14571();

            return players.stream()
                    .filter(serverPlayer -> serverPlayer.method_5781() == team)
                    .toList();
        }

        return server.method_3760().method_14571();
    }

    public void shareWithServer(MinecraftServer server, AgeEntry ageEntry) {
        this.globalAges.add(ageEntry.getId());
        this.method_80();

        List<class_3222> sharingPlayers = getSharingPlayers(server);

        GenesisFramework.LOGGER.info("Preparing to share ages with {} players", sharingPlayers.size());

        progressPlayersToAge(sharingPlayers, ageEntry);
    }

    public void shareWithTeam(class_3222 player, AgeEntry ageEntry) {
        class_268 team = player.method_5781();

        if (team != null) {
            String teamName = team.method_1197();
            Set<class_2960> ages = teamAges.getOrDefault(teamName, new HashSet<>());
            ages.add(ageEntry.getId());

            teamAges.put(teamName, ages);
            this.method_80();

            List<class_3222> sharingPlayers = getSharingPlayers(player.method_5682(), team);

            GenesisFramework.LOGGER.info("Preparing to shared ages with {} players on team {}", sharingPlayers.size(), teamName);

            progressPlayersToAge(sharingPlayers, ageEntry);
        }
    }

    public static void progressPlayerToAge(class_3222 player, AgeEntry ageEntry) {
        progressPlayersToAge(List.of(player), ageEntry);
    }

    public static int progressPlayersToAge(Collection<class_3222> players, AgeEntry ageEntry) {
        Optional<class_2960> parentAgeId = ageEntry.getAge().parent();

        int success = 0;

        if (parentAgeId.isPresent() && ageEntry.getAge().requiresParent()) {
            AgeManager ageManager = AgeManager.getInstance();
            Optional<AgeEntry> optionalParentAgeEntry = ageManager.get(parentAgeId.get());
            optionalParentAgeEntry.ifPresent(entry -> progressPlayersToAge(players, entry));
        }

        for (class_3222 player : players) {
            if (AdvancementHelper.giveAdvancement(player, ageEntry.getAdvancementEntry())) {
                ++success;
            }
        }

        return success;
    }

    public void unpack(Packed packed) {
        this.globalAges.addAll(packed.globalAges());
        packed.teamAges().forEach((team, ages) -> this.teamAges.put(team, new HashSet<>(ages)));
    }

    public Packed pack() {
        List<class_2960> globalAges = this.globalAges.stream().toList();

        Map<String, List<class_2960>> teamAges = this.teamAges.entrySet()
                .stream()
                .collect(Collectors.toMap(
                        Map.Entry::getKey,
                        entry -> new ArrayList<>(entry.getValue())
                ));


        return new Packed(
                globalAges,
                teamAges
        );
    }

    public record Packed(
            List<class_2960> globalAges,
            Map<String, List<class_2960>> teamAges
    ) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(
                instance -> instance.group(
                                class_2960.field_25139.listOf()
                                        .optionalFieldOf("GlobalAges", List.of())
                                        .forGetter(Packed::globalAges),
                                Codec.unboundedMap(Codec.STRING, class_2960.field_25139.listOf())
                                        .optionalFieldOf("TeamAges", Map.of())
                                        .forGetter(Packed::teamAges)
                        )
                        .apply(instance, Packed::new)
        );
    }
}
