package dev.mariany.genesisframework.client.age;

import dev.mariany.genesisframework.GenesisFramework;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_310;
import net.minecraft.class_366;
import net.minecraft.class_374;
import java.util.*;

@Environment(EnvType.CLIENT)
public class ClientAgeManager {
    private static final ClientAgeManager INSTANCE = new ClientAgeManager();

    private final List<class_1856> lockedItems = new ArrayList<>();
    private boolean initiatedLockedItems = false;

    private ClientAgeManager() {
    }

    public static ClientAgeManager getInstance() {
        return INSTANCE;
    }

    public void reset() {
        GenesisFramework.LOGGER.info("Resetting Client Age Manager");

        lockedItems.clear();
        initiatedLockedItems = false;
    }

    public boolean isUnlocked(class_1799 stack) {
        return lockedItems.stream().noneMatch(ingredient -> ingredient.method_8093(stack));
    }

    public void updateLockedItems(Collection<class_1856> changes) {
        boolean initial = !initiatedLockedItems;
        int oldSize = lockedItems.size();
        List<class_1856> difference = getDifference(lockedItems, changes);

        lockedItems.clear();
        lockedItems.addAll(changes);
        initiatedLockedItems = true;

        GenesisFramework.LOGGER.info("Updated age instructions. Old Size: {} | New Size: {}", oldSize, lockedItems.size());

        if (!initial) {
            afterUpdateItemUnlocks(difference);
        }
    }

    private static List<class_1856> getDifference(
            Collection<class_1856> before,
            Collection<class_1856> after
    ) {
        Set<class_1856> ingredients = new HashSet<>(after);
        return before.stream()
                .filter(oldIngredient -> !ingredients.contains(oldIngredient))
                .toList();
    }

    private void afterUpdateItemUnlocks(Collection<class_1856> changes) {
        class_310 client = class_310.method_1551();
        class_374 toastManager = client.method_1566();

        for (class_1856 ingredient : changes) {
            ingredient.method_8105().forEach(entry -> class_366.method_1985(toastManager,
                            new class_10295() {
                                @Override
                                public class_10302 comp_3258() {
                                    return new class_10302.class_10307(entry.comp_349().method_7854());
                                }

                                @Override
                                public class_10302 comp_3259() {
                                    return new class_10302.class_10307(class_1802.field_8162.method_7854());
                                }

                                @Override
                                public class_10296<? extends class_10295> method_64726() {
                                    return null;
                                }
                            }
                    )
            );
        }
    }
}
