package dev.mariany.genesisframework.client.instruction;

import dev.mariany.genesisframework.GenesisFramework;
import dev.mariany.genesisframework.client.toast.HideableToast;
import dev.mariany.genesisframework.client.toast.InstructionToast;
import dev.mariany.genesisframework.client.toast.InstructionsCompleteToast;
import dev.mariany.genesisframework.config.ConfigHandler;
import dev.mariany.genesisframework.mixin.accessor.ClientAdvancementManagerAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.advancement.*;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_163;
import net.minecraft.class_167;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_632;
import net.minecraft.class_746;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import net.minecraft.class_8828;
import org.jetbrains.annotations.Nullable;

import java.util.*;

@Environment(EnvType.CLIENT)
public class ClientInstructionManager {
    private static final ClientInstructionManager INSTANCE = new ClientInstructionManager();

    private static final class_2960 INSTRUCTIONS_COMPLETE_TOAST_ID = GenesisFramework.id("instructions_complete");

    private static final int QUEUE_DELAY_MS = 700;

    private final Set<class_2960> instructionAdvancements = new HashSet<>();
    private final Object2ObjectOpenHashMap<class_2960, HideableToast> toasts = new Object2ObjectOpenHashMap<>();
    private final Object2ObjectOpenHashMap<class_2960, HideableToast> waitingToasts = new Object2ObjectOpenHashMap<>();

    private boolean complete = true;
    private long queueTargetMs = -1;

    private ClientInstructionManager() {
    }

    public static ClientInstructionManager getInstance() {
        return INSTANCE;
    }

    public void reset() {
        GenesisFramework.LOGGER.info("Resetting instructions state");

        this.complete = true;
        this.queueTargetMs = -1;
        this.instructionAdvancements.clear();
        this.waitingToasts.clear();
        this.toasts.forEach((id, toast) -> toast.hide());
        this.toasts.clear();
    }

    public void update() {
        if (!this.waitingToasts.isEmpty()) {
            if (this.queueTargetMs > 0 && this.queueTargetMs <= class_156.method_658()) {
                this.toasts.putAll(waitingToasts);

                waitingToasts.values()
                        .forEach(toast -> class_310.method_1551().method_1566().method_1999(toast));

                this.waitingToasts.clear();
                this.queueTargetMs = -1;
            }
        }
    }

    public void updateInstructionAdvancements(Collection<class_2960> changes) {
        if (ConfigHandler.getConfig().enableInstructions) {
            int oldSize = this.instructionAdvancements.size();
            this.reset();
            this.instructionAdvancements.addAll(changes);

            GenesisFramework.LOGGER.info("Loaded instructions. Old Size: {} | New Size: {}",
                    oldSize,
                    this.instructionAdvancements.size()
            );

            this.refreshInstructionToasts();
        }
    }

    public List<class_8781> getInstructionAdvancements() {
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;

        if (clientPlayer != null) {
            class_632 clientAdvancementManager = clientPlayer.field_3944.method_2869();
            class_163 advancementManager = clientAdvancementManager.method_53814();
            return advancementManager.method_53693().stream().filter(placedAdvancement ->
                    instructionAdvancements.contains(placedAdvancement.method_53649().comp_1919())).toList();
        }

        return List.of();
    }

    public void removeToast(class_2960 id) {
        if (this.toasts.containsKey(id)) {
            this.toasts.get(id).hide();
            this.toasts.remove(id);
        }

        this.waitingToasts.remove(id);
    }

    public void queueToast(class_2960 id, HideableToast toast) {
        this.queueTargetMs = class_156.method_658() + QUEUE_DELAY_MS;
        this.waitingToasts.put(id, toast);
    }

    public void addToast(class_8781 placedAdvancement) {
        class_310 client = class_310.method_1551();
        class_8779 advancementEntry = placedAdvancement.method_53649();
        class_2960 id = advancementEntry.comp_1919();
        class_161 advancement = advancementEntry.comp_1920();
        Optional<class_185> optionalAdvancementDisplay = advancement.comp_1913();

        removeToast(id);

        optionalAdvancementDisplay.ifPresent(advancementDisplay -> {
            @Nullable class_2561 description = advancementDisplay.method_817();

            if (description instanceof class_8828 plainTextContent) {
                if (plainTextContent.comp_737().isEmpty()) {
                    description = null;
                }
            }

            queueToast(id, new InstructionToast(
                    client.field_1772,
                    advancementDisplay.method_821(),
                    advancementDisplay.method_811(),
                    description
            ));
        });

        resetCompleteToast();
    }

    private void resetCompleteToast() {
        this.complete = false;

        HideableToast toast = this.toasts.get(INSTRUCTIONS_COMPLETE_TOAST_ID);

        if (toast != null) {
            toast.hide();
        }

        this.toasts.remove(INSTRUCTIONS_COMPLETE_TOAST_ID);
        this.waitingToasts.remove(INSTRUCTIONS_COMPLETE_TOAST_ID);
    }

    public void refreshInstructionToasts() {
        List<class_8781> instructionList = getInstructionAdvancements();

        for (class_8781 placed : instructionList) {
            Optional<class_167> optionalAdvancementProgress = getAdvancementProgress(placed);
            class_2960 id = placed.method_53649().comp_1919();

            if (optionalAdvancementProgress.isPresent()) {
                class_167 progress = optionalAdvancementProgress.get();

                boolean isDone = progress.method_740();
                boolean isParentComplete = isParentComplete(placed);

                if (isDone || !isParentComplete) {
                    removeToast(id);
                } else if (!this.toasts.containsKey(id)) {
                    addToast(placed);
                }
            }
        }

        if (!instructionList.isEmpty() && (this.toasts.isEmpty() && this.waitingToasts.isEmpty())) {
            if (!this.complete) {
                this.complete = true;
                queueToast(INSTRUCTIONS_COMPLETE_TOAST_ID, new InstructionsCompleteToast());
            }
        }
    }

    private Optional<class_167> getAdvancementProgress(class_8781 placedAdvancement) {
        return getAdvancementProgress(placedAdvancement.method_53649());
    }

    private Optional<class_167> getAdvancementProgress(class_8779 advancementEntry) {
        class_310 client = class_310.method_1551();
        class_746 clientPlayer = client.field_1724;

        if (clientPlayer != null) {
            class_632 clientAdvancementManager = clientPlayer.field_3944.method_2869();
            Map<class_8779, class_167> advancementProgresses = (
                    (ClientAdvancementManagerAccessor) clientAdvancementManager
            ).genesis$advancementProgresses();

            if (advancementProgresses.containsKey(advancementEntry)) {
                return Optional.of(advancementProgresses.get(advancementEntry));
            }
        }

        return Optional.empty();
    }

    private boolean isParentComplete(class_8781 advancement) {
        class_8781 parent = advancement.method_53651();

        if (parent == null) {
            return true;
        }

        Optional<class_167> optionalParentProgress = getAdvancementProgress(parent);

        if (optionalParentProgress.isPresent()) {
            class_167 parentProgress = optionalParentProgress.get();
            if (!parentProgress.method_740()) {
                return false;
            }
        }

        return isParentComplete(parent);
    }
}
