package dev.mariany.genesisframework.client.toast;

import dev.mariany.genesisframework.GenesisFramework;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5481;
import net.minecraft.class_8012;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class InstructionToast implements HideableToast {
    private static final class_2960 TEXTURE = GenesisFramework.id("toast/instruction");
    private static final class_2960 ICON_TEXTURE = GenesisFramework.id("toast/information");

    private static final int ICON_SIZE = 8;
    private static final int HALF_ICON_SIZE = ICON_SIZE / 2;

    private static final int MAX_TEXT_ROWS = 2;
    private static final int TEXT_COLOR = 0xFF000000;
    private static final int TEXT_LINE_HEIGHT = 11;
    private static final int TEXT_WIDTH = 126;
    private static final int TOAST_PADDING_BOTTOM = 3;
    private static final int TOAST_PADDING_TOP = 7;

    private class_368.class_369 visibility = class_368.class_369.field_2210;
    private final class_1799 icon;
    private final List<class_5481> text;

    public InstructionToast(class_327 textRenderer, class_1799 icon, class_2561 title, @Nullable class_2561 description) {
        this.icon = icon;

        this.text = new ArrayList<>(MAX_TEXT_ROWS);
        this.text.addAll(textRenderer.method_1728(title.method_27661().method_54663(class_8012.field_52393), TEXT_WIDTH));

        if (description != null) {
            this.text.addAll(textRenderer.method_1728(description, TEXT_WIDTH));
        }
    }

    @Override
    public class_368.class_369 method_61988() {
        return this.visibility;
    }

    public void hide() {
        this.visibility = class_368.class_369.field_2209;
    }

    @Override
    public void method_61989(class_374 manager, long time) {
    }

    @Override
    public int method_29050() {
        return TOAST_PADDING_TOP + this.getTextHeight() + TOAST_PADDING_BOTTOM;
    }

    private int getTextHeight() {
        return Math.max(this.text.size(), MAX_TEXT_ROWS) * TEXT_LINE_HEIGHT;
    }

    @Override
    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        context.method_52706(class_10799.field_56883, TEXTURE, 0, 0, this.method_29049(), this.method_29050());

        context.method_52706(
                class_10799.field_56883,
                ICON_TEXTURE,
                -HALF_ICON_SIZE,
                1,
                ICON_SIZE,
                ICON_SIZE
        );

        int totalTextHeight = this.text.size() * TEXT_LINE_HEIGHT;
        int verticalTextOffset = TOAST_PADDING_TOP + (this.getTextHeight() - totalTextHeight) / 2;

        for (int lineIndex = 0; lineIndex < this.text.size(); lineIndex++) {
            int y = verticalTextOffset + lineIndex * TEXT_LINE_HEIGHT;

            context.method_51430(
                    textRenderer,
                    this.text.get(lineIndex),
                    30,
                    y,
                    TEXT_COLOR,
                    false
            );
        }

        context.method_51445(this.icon, 8, 8);
    }
}
