package dev.mariany.genesisframework.client.toast;

import dev.mariany.genesisframework.GenesisFramework;
import dev.mariany.genesisframework.sound.GFSoundEvents;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_8012;

@Environment(EnvType.CLIENT)
public class InstructionsCompleteToast implements HideableToast {
    private static final class_2960 TEXTURE = GenesisFramework.id("toast/instruction");
    private static final class_2960 INFORMATION_ICON_TEXTURE = GenesisFramework.id("toast/information");
    private static final class_2960 COMPLETE_ICON_TEXTURE = GenesisFramework.id("toast/complete");

    private static final int BAR_COLOR = 0xFF00AA00;

    private static final int INFORMATION_ICON_SIZE = 8;
    private static final int HALF_INFORMATION_ICON_SIZE = INFORMATION_ICON_SIZE / 2;

    private static final int COMPLETE_ICON_SIZE = 16;
    private static final int HALF_COMPLETE_ICON_SIZE = COMPLETE_ICON_SIZE / 2;

    private static final int TITLE_X = COMPLETE_ICON_SIZE * 2;
    private static final int TITLE_Y = 12;

    private static final class_2561 TITLE = class_2561.method_43471("instruction.genesisframework.complete.title");

    private final int displayDuration;
    private long lastTime;
    private float lastProgress;
    private class_369 visibility = class_369.field_2210;

    public InstructionsCompleteToast() {
        this(8000);
    }

    public InstructionsCompleteToast(int displayDuration) {
        this.displayDuration = displayDuration;
    }

    @Override
    public class_3414 method_66530() {
        return GFSoundEvents.UI_TOAST_INSTRUCTIONS_COMPLETE;
    }

    @Override
    public class_369 method_61988() {
        return this.visibility;
    }

    @Override
    public void hide() {
        this.visibility = class_369.field_2209;
    }

    @Override
    public void method_61989(class_374 manager, long time) {
        float progress = Math.min((float) time / this.displayDuration, 1.0F);

        this.lastProgress = class_3532.method_37166(
                this.lastProgress,
                progress,
                (time - this.lastTime) / 100F
        );
        this.lastTime = time;

        if (time >= this.displayDuration) {
            this.visibility = class_368.class_369.field_2209;
        }
    }

    @Override
    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        context.method_52706(class_10799.field_56883, TEXTURE, 0, 0, this.method_29049(), this.method_29050());

        context.method_52706(
                class_10799.field_56883,
                INFORMATION_ICON_TEXTURE,
                -HALF_INFORMATION_ICON_SIZE,
                1,
                INFORMATION_ICON_SIZE,
                INFORMATION_ICON_SIZE
        );

        context.method_52706(
                class_10799.field_56883,
                COMPLETE_ICON_TEXTURE,
                HALF_COMPLETE_ICON_SIZE,
                HALF_COMPLETE_ICON_SIZE,
                COMPLETE_ICON_SIZE,
                COMPLETE_ICON_SIZE
        );

        context.method_51439(textRenderer, TITLE, TITLE_X, TITLE_Y, class_8012.field_52393, false);

        this.drawProgressBar(context);
    }

    private void drawProgressBar(class_332 context) {
        int barY = this.method_29050() - 4;
        context.method_25294(3, barY, 157, barY + 1, class_8012.field_42973);
        context.method_25294(3, barY, (int) (3.0F + 154.0F * this.lastProgress), barY + 1, BAR_COLOR);
    }
}
