package dev.mariany.genesisframework.datagen;

import dev.mariany.genesisframework.advancement.criterion.OpenAdvancementTabCriteria;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.instruction.Instruction;
import dev.mariany.genesisframework.instruction.InstructionEntry;
import dev.mariany.genesisframework.item.GFItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class GFInstructionProvider extends InstructionProvider {
    public GFInstructionProvider(
            FabricDataOutput output,
            CompletableFuture<class_7225.class_7874> registryLookup
    ) {
        super(output, registryLookup);
    }

    @Override
    public void generateInstructions(class_7225.class_7874 registryLookup, Consumer<InstructionEntry> consumer) {
        Instruction.Builder.create()
                .display(
                        GFItems.AGE_BOOK,
                        class_2561.method_43471("instruction.genesisframework.view_ages"),
                        class_2561.method_43469("instruction.genesisframework.view_ages.description",
                                class_2561.method_43472(class_310.method_1551().field_1690.field_1844.method_1431())
                        )
                )
                .criterion("view_ages", OpenAdvancementTabCriteria.Conditions.create(AgeEntry.ROOT_ADVANCEMENT_ID))
                .build(consumer, InstructionEntry.VIEW_AGES_INSTRUCTION_ID);
    }

    @Override
    public String method_10321() {
        return "Genesis Framework Instructions";
    }
}
