package dev.mariany.genesisframework.datagen;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import dev.mariany.genesisframework.instruction.Instruction;
import dev.mariany.genesisframework.instruction.InstructionEntry;
import dev.mariany.genesisframework.registry.GFRegistryKeys;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.impl.datagen.FabricDataGenHelper;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class InstructionProvider implements class_2405 {
    protected final FabricDataOutput output;
    private final class_7784.class_7489 pathResolver;
    private final CompletableFuture<class_7225.class_7874> registryLookup;

    public InstructionProvider(
            FabricDataOutput output,
            CompletableFuture<class_7225.class_7874> registryLookup
    ) {
        this.output = output;
        this.pathResolver = output.method_60917(GFRegistryKeys.INSTRUCTION);
        this.registryLookup = registryLookup;
    }

    public abstract void generateInstructions(
            class_7225.class_7874 registryLookup,
            Consumer<InstructionEntry> consumer
    );

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.registryLookup.thenCompose(lookup -> {
            final Set<class_2960> identifiers = Sets.newHashSet();
            final Set<InstructionEntry> instructions = Sets.newHashSet();

            generateInstructions(lookup, instructions::add);

            class_6903<JsonElement> ops = lookup.method_57093(JsonOps.INSTANCE);
            final List<CompletableFuture<?>> futures = new ArrayList<>();

            for (InstructionEntry instructionEntry : instructions) {
                class_2960 id = instructionEntry.getId();

                if (!identifiers.add(id)) {
                    throw new IllegalStateException("Duplicate instruction " + instructionEntry.getId());
                }

                JsonObject advancementJson = Instruction.CODEC.encodeStart(
                        ops,
                        instructionEntry.getInstruction()
                ).getOrThrow(IllegalStateException::new).getAsJsonObject();

                FabricDataGenHelper.addConditions(
                        advancementJson,
                        FabricDataGenHelper.consumeConditions(instructionEntry)
                );

                futures.add(class_2405.method_10320(writer, advancementJson, getOutputPath(instructionEntry)));
            }

            return CompletableFuture.allOf(futures.toArray(CompletableFuture[]::new));
        });
    }

    private Path getOutputPath(InstructionEntry instruction) {
        return pathResolver.method_44107(instruction.getId());
    }
}
