package dev.mariany.genesisframework.event.block;

import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeLockNotifier;
import dev.mariany.genesisframework.age.AgeManager;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class UseBlockHandler {
    public static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 result) {
        if (player instanceof class_3222 serverPlayer) {
            AgeManager ageManager = AgeManager.getInstance();
            class_2680 state = world.method_8320(result.method_17777());
            class_2248 block = state.method_26204();

            if (!ageManager.isUnlocked(serverPlayer, block)) {
                String itemTranslation = block.method_9518().getString();

                Optional<AgeEntry> optionalAgeEntry = ageManager.getRequiredAges(block.method_8389().method_7854())
                        .stream()
                        .findAny();

                optionalAgeEntry.ifPresent(ageEntry ->
                        AgeLockNotifier.notifyAgeLockedClick(itemTranslation, ageEntry.getAge(), serverPlayer)
                );

                return class_1269.field_5814;
            }
        }

        return class_1269.field_5811;
    }
}
