package dev.mariany.genesisframework.event.server.advancement;

import dev.mariany.genesisframework.GenesisFramework;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeManager;
import dev.mariany.genesisframework.config.ConfigHandler;
import dev.mariany.genesisframework.instruction.InstructionEntry;
import dev.mariany.genesisframework.instruction.InstructionManager;
import dev.mariany.genesisframework.item.GFItems;
import net.minecraft.advancement.*;
import net.minecraft.class_10726;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_1802;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import java.util.*;

public class BeforeAdvancementsLoadHandler {
    public static void beforeAdvancementsLoad(
            Map<class_2960, class_161> advancementMap
    ) {
        loadAgeAdvancements(advancementMap);
    }

    private static void loadAgeAdvancements(Map<class_2960, class_161> advancementMap) {
        AgeManager ageManager = AgeManager.getInstance();
        InstructionManager instructionManager = InstructionManager.getInstance();

        List<class_8779> advancements = getAdvancementEntries(ageManager, instructionManager);

        for (class_8779 advancementEntry : advancements) {
            advancementMap.put(advancementEntry.comp_1919(), advancementEntry.comp_1920());
        }

        GenesisFramework.LOGGER.info("Dynamically added {} age advancements successfully!", advancements.size());
    }

    private static List<class_8779> getAdvancementEntries(
            AgeManager ageManager,
            InstructionManager instructionManager
    ) {
        boolean instructionsEnabled = ConfigHandler.getConfig().enableInstructions;
        Collection<AgeEntry> ages = ageManager.getAges();
        Collection<InstructionEntry> instructions = instructionManager.getInstructions();
        List<class_8779> advancements = new ArrayList<>();

        advancements.add(getRootAgeAdvancement());

        if (instructionsEnabled) {
            advancements.add(getRootInstructionAdvancement());
        }

        for (AgeEntry ageEntry : ages) {
            advancements.add(ageEntry.getAdvancementEntry());
        }

        if (instructionsEnabled) {
            for (InstructionEntry instructionEntry : instructions) {
                advancements.add(instructionEntry.getAdvancementEntry());
            }
        }

        return advancements;
    }

    private static class_8779 getRootAgeAdvancement() {
        return new class_8779(AgeEntry.ROOT_ADVANCEMENT_ID,
                new class_161(
                        Optional.empty(),
                        Optional.of(new class_185(
                                GFItems.AGE_BOOK.method_7854(),
                                class_2561.method_43471("advancements.genesisframework.ages.title"),
                                class_2561.method_43473(),
                                Optional.of(new class_10726(class_2960.method_60656("block/dark_oak_planks"))),
                                class_189.field_1254,
                                false,
                                false,
                                false
                        )),
                        class_170.field_1167,
                        Map.of(
                                "root",
                                new class_175<>(
                                        class_174.field_1187, class_2135.class_2137.method_49195().comp_1924()
                                )
                        ),
                        class_8782.method_53668(List.of("root")),
                        false
                )
        );
    }

    private static class_8779 getRootInstructionAdvancement() {
        return new class_8779(InstructionEntry.ROOT_ADVANCEMENT_ID,
                new class_161(
                        Optional.empty(),
                        Optional.of(new class_185(
                                class_1802.field_8251.method_7854(),
                                class_2561.method_43471("advancements.genesisframework.instructions.title"),
                                class_2561.method_43473(),
                                Optional.of(new class_10726(class_2960.method_60656("block/lime_terracotta"))),
                                class_189.field_1254,
                                false,
                                false,
                                false
                        )),
                        class_170.field_1167,
                        Map.of(
                                "root",
                                new class_175<>(
                                        class_174.field_1187, class_2135.class_2137.method_49195().comp_1924()
                                )
                        ),
                        class_8782.method_53668(List.of("root")),
                        false
                )
        );
    }
}
