package dev.mariany.genesisframework.instruction;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_8782;

public record Instruction(
        Optional<class_2960> parent,
        Map<String, class_175<?>> criteria,
        class_8782 requirements,
        Optional<InstructionDisplay> display
) {
    private static final Codec<Map<String, class_175<?>>> CRITERIA_CODEC = Codec.unboundedMap(
            Codec.STRING,
            class_175.field_47188
    );
    public static final Codec<Instruction> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                            class_2960.field_25139.optionalFieldOf("parent").forGetter(Instruction::parent),
                            CRITERIA_CODEC.optionalFieldOf("criteria", new HashMap<>()).forGetter(Instruction::criteria),
                            class_8782.field_47184.optionalFieldOf("requirements", class_8782.field_46084)
                                    .forGetter(Instruction::requirements),
                            InstructionDisplay.CODEC.optionalFieldOf("display").forGetter(Instruction::display)
                    )
                    .apply(instance, Instruction::new)
    );

    @SuppressWarnings("unused")
    public static class Builder {
        @Nullable
        private class_2960 parent = null;
        private final Map<String, class_175<?>> criteria = new HashMap<>();
        private class_8782 requirements = class_8782.field_46084;
        @Nullable
        private InstructionDisplay display = null;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder parent(InstructionEntry parent) {
            return parent(parent.getId());
        }

        public Builder parent(class_2960 parent) {
            this.parent = parent;
            return this;
        }

        public Builder requirements(class_8782 advancementRequirements) {
            this.requirements = advancementRequirements;
            return this;
        }

        public Builder criterion(String name, class_175<?> criterion) {
            this.criteria.put(name, criterion);
            return this;
        }

        public Builder display(InstructionDisplay display) {
            this.display = display;
            return this;
        }

        public Builder display(class_1792 icon, class_2561 title) {
            return display(icon, title, class_2561.method_43473());
        }

        public Builder display(class_1792 icon, class_2561 title, class_2561 description) {
            this.display = new InstructionDisplay(icon.method_7854(), title, description);
            return this;
        }

        public InstructionEntry build(class_2960 id) {
            if (this.requirements.method_53677()) {
                this.requirements = class_8782.method_53668(this.criteria.keySet());
            }

            return new InstructionEntry(id, new Instruction(
                    Optional.ofNullable(this.parent),
                    this.criteria,
                    this.requirements,
                    Optional.ofNullable(this.display)
            ));
        }

        @SuppressWarnings("UnusedReturnValue")
        public InstructionEntry build(Consumer<InstructionEntry> exporter, class_2960 id) {
            InstructionEntry instructionEntry = this.build(id);
            exporter.accept(instructionEntry);
            return instructionEntry;
        }
    }
}
