package dev.mariany.genesisframework.instruction;

import com.google.common.collect.ImmutableMap;
import dev.mariany.genesisframework.config.ConfigHandler;
import dev.mariany.genesisframework.registry.GFRegistryKeys;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7225;

public class InstructionDataLoader extends class_4309<Instruction> {
    public InstructionDataLoader(class_7225.class_7874 registries) {
        super(registries, Instruction.CODEC, GFRegistryKeys.INSTRUCTION);
    }

    @Override
    protected void apply(Map<class_2960, Instruction> map, class_3300 manager, class_3695 profiler) {
        if (ConfigHandler.getConfig().enableInstructions) {
            InstructionManager instructionManager = InstructionManager.getInstance();
            instructionManager.clear();

            ImmutableMap.Builder<class_2960, InstructionEntry> builder = ImmutableMap.builder();

            map.forEach((id, instruction) -> builder.put(id, new InstructionEntry(id, instruction)));

            builder.buildOrThrow().values().forEach(instructionManager::add);
        }
    }
}
