package dev.mariany.genesisframework.instruction;

import dev.mariany.genesisframework.GenesisFramework;
import net.minecraft.advancement.*;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2960;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import java.util.Map;
import java.util.Optional;

public class InstructionEntry {
    public static final String ADVANCEMENT_PREFIX = "instruction/";
    public static final class_2960 ROOT_ADVANCEMENT_ID = GenesisFramework.id(ADVANCEMENT_PREFIX + "root");
    public static final class_2960 VIEW_AGES_INSTRUCTION_ID = GenesisFramework.id("view_ages");

    private final class_2960 id;
    private final Instruction instruction;
    private final class_8779 advancementEntry;

    public InstructionEntry(class_2960 id, Instruction instruction) {
        this.id = id;
        this.instruction = instruction;
        this.advancementEntry = createAdvancementEntry(id, instruction);
    }

    private class_8779 createAdvancementEntry(class_2960 id, Instruction instruction) {
        return new class_8779(getAdvancementId(id), createAdvancement(instruction));
    }

    public static class_161 createAdvancement(Instruction instruction) {
        class_2960 parent = instruction.parent()
                .map(InstructionEntry::getAdvancementId)
                .orElse(ROOT_ADVANCEMENT_ID);

        Map<String, class_175<?>> criteria = instruction.criteria();

        class_8782 requirements = instruction.requirements().method_53677() ?
                class_8782.method_53668(criteria.keySet()) :
                instruction.requirements();

        return new class_161(
                Optional.of(parent),
                createAdvancementDisplay(instruction),
                class_170.field_1167,
                criteria,
                requirements,
                false
        );
    }

    private static Optional<class_185> createAdvancementDisplay(Instruction instruction) {
        Optional<InstructionDisplay> optionalInstructionDisplay = instruction.display();

        if (optionalInstructionDisplay.isEmpty()) {
            return Optional.empty();
        }

        InstructionDisplay instructionDisplay = optionalInstructionDisplay.get();

        return Optional.of(new class_185(
                instructionDisplay.icon(),
                instructionDisplay.title(),
                instructionDisplay.description(),
                Optional.empty(),
                class_189.field_1254,
                false,
                false,
                false
        ));
    }

    public static class_2960 getAdvancementId(class_2960 id) {
        return id.method_45138(ADVANCEMENT_PREFIX);
    }

    public class_2960 getId() {
        return this.id;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public class_8779 getAdvancementEntry() {
        return this.advancementEntry;
    }
}
