package dev.mariany.genesisframework.instruction;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_8779;

public class InstructionManager {
    private static final InstructionManager INSTANCE = new InstructionManager();

    private final Map<class_2960, InstructionEntry> instructions = new Object2ObjectOpenHashMap<>();

    public static InstructionManager getInstance() {
        return INSTANCE;
    }

    public Optional<InstructionEntry> find(class_8779 advancementEntry) {
        return instructions
                .values()
                .stream()
                .filter(
                        instructionEntry ->
                                instructionEntry.getAdvancementEntry().comp_1919().equals(advancementEntry.comp_1919())
                )
                .findAny();
    }

    public Collection<InstructionEntry> getInstructions() {
        return this.instructions.values();
    }

    public List<class_2960> getInstructionAdvancementIds() {
        return this.instructions.values()
                .stream()
                .map(instructionEntry -> instructionEntry.getAdvancementEntry().comp_1919()).toList();
    }

    protected void add(InstructionEntry instructionEntry) {
        this.instructions.put(instructionEntry.getId(), instructionEntry);
    }

    protected void clear() {
        this.instructions.clear();
    }
}
