package dev.mariany.genesisframework.item;

import dev.mariany.genesisframework.GenesisFramework;
import dev.mariany.genesisframework.advancement.AdvancementHelper;
import dev.mariany.genesisframework.age.Age;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeManager;
import dev.mariany.genesisframework.component.GFComponentTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5321;

public class AgeBookItem extends class_1792 {
    public AgeBookItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);

        List<class_5321<Age>> ages = itemStack.method_58695(GFComponentTypes.AGES, List.of());
        itemStack.method_57008(1, player);

        if (ages.isEmpty()) {
            return class_1269.field_5814;
        }

        if (player instanceof class_3222 serverPlayer) {
            AgeManager ageManager = AgeManager.getInstance();

            for (class_5321<Age> ageKey : ages) {
                Optional<AgeEntry> optionalAgeEntry = ageManager.get(ageKey.method_29177());

                if (optionalAgeEntry.isPresent()) {
                    AgeEntry ageEntry = optionalAgeEntry.get();
                    AdvancementHelper.giveAdvancement(serverPlayer, ageEntry.getAdvancementEntry());
                } else {
                    GenesisFramework.LOGGER.error("Invalid age: {}", ageKey);
                }
            }

            player.method_7259(class_3468.field_15372.method_14956(this));
        }

        return class_1269.field_5812;
    }
}
