package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeManager;
import dev.mariany.genesisframework.instruction.InstructionEntry;
import dev.mariany.genesisframework.instruction.InstructionManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_8005;
import net.minecraft.class_8781;

@Mixin(class_8005.class)
public class AdvancementDisplaysMixin {
    /**
     * Enforce advancement to be displayed and thus sent to client if it belongs to an age or instruction.
     */
    @WrapOperation(
            method = "shouldDisplay(Lnet/minecraft/advancement/PlacedAdvancement;Lit/unimi/dsi/fastutil/Stack;Ljava/util/function/Predicate;Lnet/minecraft/advancement/AdvancementDisplays$ResultConsumer;)Z",
            at = @At(value = "INVOKE", target = "Ljava/util/function/Predicate;test(Ljava/lang/Object;)Z")
    )
    private static boolean wrapShouldDisplay(
            Predicate<class_8781> predicate, Object object, Operation<Boolean> original
    ) {
        if (object instanceof class_8781 placedAdvancement) {
            Optional<AgeEntry> optionalAge = AgeManager.getInstance().find(placedAdvancement.method_53649());

            if (optionalAge.isPresent()) {
                return true;
            }

            Optional<InstructionEntry> optionalInstruction = InstructionManager.getInstance().find(
                    placedAdvancement.method_53649()
            );

            if (optionalInstruction.isPresent()) {
                return true;
            }
        }

        return original.call(predicate, object);
    }
}
