package dev.mariany.genesisframework.mixin;

import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.config.ConfigHandler;
import dev.mariany.genesisframework.instruction.InstructionEntry;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_454;
import net.minecraft.class_457;
import net.minecraft.class_632;
import net.minecraft.class_8779;
import net.minecraft.class_8781;

@Mixin(class_457.class)
public abstract class AdvancementsScreenMixin {
    @Shadow
    @Final
    private Map<class_8779, class_454> tabs;

    @Shadow
    public abstract void selectTab(@Nullable class_8779 advancement);

    @Shadow
    @Final
    private class_632 advancementHandler;

    /**
     * Start on Age tab if advancement present.
     */
    @Inject(method = "init", at = @At(value = "TAIL"))
    public void injectInit(CallbackInfo ci) {
        if (ConfigHandler.getConfig().alwaysStartOnAgesAdvancementScreen) {
            Optional<class_8779> optionalAgeRoot = this.tabs.keySet()
                    .stream()
                    .filter(advancementEntry -> advancementEntry.comp_1919().equals(AgeEntry.ROOT_ADVANCEMENT_ID))
                    .findFirst();

            optionalAgeRoot.ifPresent(advancementEntry -> {
                this.selectTab(advancementEntry);
                this.advancementHandler.method_2864(advancementEntry, true);
            });
        }
    }

    /**
     * Prevents instruction tab from being added.
     */
    @Inject(method = "onRootAdded", at = @At(value = "HEAD"), cancellable = true)
    public void injectOnRootAdded(class_8781 root, CallbackInfo ci) {
        if (root.method_53649().comp_1919().equals(InstructionEntry.ROOT_ADVANCEMENT_ID)) {
            ci.cancel();
        }
    }
}
