package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import net.minecraft.class_514;

@Mixin(class_514.class)
public class AnimatedResultButtonMixin {
    @Shadow
    private List<class_514.class_10330> results;

    /**
     * Remove any {@link class_514.class_10330} that have empty {@link class_514.class_10330#comp_3291()}
     */
    @WrapOperation(
            method = "showResultCollection",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/screen/recipebook/AnimatedResultButton;areAllResultsEqual(Ljava/util/List;)Z"
            )
    )
    public boolean injectShowResultCollection(
            List<class_514.class_10330> results, Operation<Boolean> original
    ) {
        this.results = this.results.stream().filter(result -> !result.comp_3291().isEmpty()).toList();
        return original.call(this.results);
    }
}
