package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.client.age.ClientAgeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import net.minecraft.class_10297;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_1799;

@Mixin(class_10297.class)
public class ClientRecipeDisplayEntryMixin {
    /**
     * Filter out any locked items from a recipe display.
     */
    @WrapOperation(
            method = "getStacks",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/recipe/display/SlotDisplay;getStacks(Lnet/minecraft/util/context/ContextParameterMap;)Ljava/util/List;"
            )
    )
    public List<class_1799> wrapGetStacks(
            class_10302 slotDisplay,
            class_10352 parameters,
            Operation<List<class_1799>> original
    ) {
        ClientAgeManager clientAgeManager = ClientAgeManager.getInstance();
        return original.call(slotDisplay, parameters).stream().filter(clientAgeManager::isUnlocked).toList();
    }
}
