package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.age.AgeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import net.minecraft.class_8884;
import net.minecraft.class_8886;
import net.minecraft.class_9694;

@Mixin(class_8886.class)
public class CrafterBlockMixin {
    /**
     * Prevent Crafter from crafting an item that requires an age.
     */
    @WrapOperation(
            method = "getCraftingRecipe",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/recipe/RecipeCache;getRecipe(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/recipe/input/CraftingRecipeInput;)Ljava/util/Optional;"
            )
    )
    private static Optional<class_8786<class_3955>> wrapGetCraftingRecipe(
            class_8884 recipeCache,
            class_3218 world,
            class_9694 input,
            Operation<Optional<class_8786<class_3955>>> original
    ) {
        Optional<class_8786<class_3955>> optionalRecipe = original.call(recipeCache, world, input);

        if (optionalRecipe.isPresent()) {
            class_8786<class_3955> recipe = optionalRecipe.get();
            class_1799 stack = recipe.comp_1933().method_8116(input, world.method_30349());

            if (AgeManager.getInstance().isAgeGuarded(stack.method_7909())) {
                return Optional.empty();
            }
        }

        return original.call(recipeCache, world, input);
    }
}
