package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.age.AgeDataLoader;
import dev.mariany.genesisframework.instruction.InstructionDataLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_3302;
import net.minecraft.class_5350;
import net.minecraft.class_7225;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7780;

@Mixin(class_5350.class)
public class DataPackContentsMixin {
    @Unique
    private AgeDataLoader ageLoader;

    @Unique
    private InstructionDataLoader instructionDataLoader;

    /**
     * Initiate age and instruction data loaders.
     */
    @Inject(method = "<init>", at = @At("RETURN"))
    private void onConstruct(
            class_7780<class_7659> dynamicRegistries,
            class_7225.class_7874 registries,
            class_7699 enabledFeatures,
            class_2170.class_5364 environment,
            List<class_2378.class_10106<?>> pendingTagLoads,
            int functionPermissionLevel,
            CallbackInfo ci
    ) {
        this.ageLoader = new AgeDataLoader(registries);
        this.instructionDataLoader = new InstructionDataLoader(registries);
    }

    /**
     * Include age and instruction data loaders when getting data pack contents.
     */
    @WrapOperation(method = "getContents", at = @At(value = "INVOKE", target = "Ljava/util/List;of(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/List;"))
    public List<class_3302> wrapGetContents(
            Object first,
            Object second,
            Object third,
            Operation<List<class_3302>> original
    ) {
        List<class_3302> resourceReloaders = new ArrayList<>(List.of(this.ageLoader, this.instructionDataLoader));
        resourceReloaders.addAll(original.call(first, second, third));
        return resourceReloaders;
    }
}
