package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeLockNotifier;
import dev.mariany.genesisframework.age.AgeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_6025;
import net.minecraft.class_8046;
import net.minecraft.class_9787;


@Mixin(class_1297.class)
public class EntityMixin {
    /**
     * Prevent teleporting via a portal if the target dimension is not unlocked.
     */
    @WrapOperation(
            method = "tickPortalTeleportation",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/dimension/PortalManager;createTeleportTarget(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;)Lnet/minecraft/world/TeleportTarget;"
            )
    )
    protected class_5454 wrapCreateTeleportTarget(
            class_9787 portalManager,
            class_3218 world,
            class_1297 entity,
            Operation<class_5454> original
    ) {
        class_5454 target = original.call(portalManager, world, entity);

        if (target != null) {
            boolean notify = entity instanceof class_3222;
            Optional<class_3222> optionalPlayer = getPlayerForPortalCheck(entity);

            if (optionalPlayer.isPresent()) {
                AgeManager ageManager = AgeManager.getInstance();
                class_3222 player = optionalPlayer.get();
                class_5321<class_1937> worldRegistryKey = target.comp_2820().method_27983();

                if (!ageManager.isUnlocked(player, worldRegistryKey)) {
                    Optional<AgeEntry> optionalAgeEntry = ageManager.getRequiredAges(worldRegistryKey)
                            .stream()
                            .findAny();

                    if (notify) {
                        optionalAgeEntry.ifPresent(ageEntry ->
                                AgeLockNotifier.notifyAgeLocked(
                                        "tutorial.genesisframework.ageLocked.dimension",
                                        ageEntry.getAge(),
                                        player
                                )
                        );
                    }

                    return null;
                }
            }
        }

        return target;
    }

    @Unique
    private Optional<class_3222> getPlayerForPortalCheck(class_1297 entity) {
        class_3222 player = null;

        if (entity instanceof class_3222 serverPlayer) {
            player = serverPlayer;
        } else if (entity instanceof class_8046 ownable && ownable.method_24921() instanceof class_3222 serverPlayer) {
            player = serverPlayer;
        } else if (
                entity instanceof class_6025 tameable && tameable.method_35057() instanceof class_3222 serverPlayer
        ) {
            player = serverPlayer;
        }

        return Optional.ofNullable(player);
    }
}
