package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.client.age.ClientAgeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_10297;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_507;
import net.minecraft.class_513;
import net.minecraft.class_516;

@Mixin(class_507.class)
public class RecipeBookWidgetMixin {
    @Shadow
    protected class_310 client;

    /**
     * Filter Recipe Book results if ANY of the recipe display stacks are locked, to prevent confusion.
     */
    @WrapOperation(
            method = "refreshResults",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/screen/recipebook/RecipeBookResults;setResults(Ljava/util/List;ZZ)V"
            )
    )
    private void filterLockedRecipes(
            class_513 recipeBookResults,
            List<class_516> resultCollections,
            boolean resetCurrentPage,
            boolean filteringCraftable,
            Operation<Void> original
    ) {
        ClientAgeManager clientAgeManager = ClientAgeManager.getInstance();
        class_10352 contextParameterMap = class_10363.method_65008(
                Objects.requireNonNull(this.client.field_1687)
        );

        List<class_516> filteredRecipes = resultCollections.stream().filter(resultCollection -> {
            for (class_10297 recipe : resultCollection.method_2650()) {
                List<class_1799> stacks = recipe.method_64730(contextParameterMap);
                if (stacks.stream().filter(clientAgeManager::isUnlocked).findAny().isEmpty()) {
                    return false;
                }
            }
            return true;
        }).toList();

        original.call(recipeBookResults, filteredRecipes, resetCurrentPage, filteringCraftable);
    }
}
