package dev.mariany.genesisframework.mixin;

import dev.mariany.genesisframework.age.AgeManager;
import net.minecraft.class_1732;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3955;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1732.class)
public interface RecipeUnlockerMixin {
    /**
     * Check if an item is unlocked when calling {@link class_1732#method_7665(class_3222, class_8786)}.
     */
    @Inject(
            method = "shouldCraftRecipe",
            at = @At("HEAD"),
            cancellable = true
    )
    private void injectShouldCraftRecipe(
            class_3222 player,
            class_8786<?> recipe,
            CallbackInfoReturnable<Boolean> cir
    ) {
        class_3218 serverWorld = player.method_51469();
        class_7225.class_7874 registries = serverWorld.method_30349();
        AgeManager ageManager = AgeManager.getInstance();

        if (recipe.comp_1933() instanceof class_3955 craftingRecipe) {
            class_1799 stack = craftingRecipe.method_8116(class_9694.field_51631, registries);

            if (!ageManager.isUnlocked(player, stack) && !player.method_68878()) {
                cir.setReturnValue(false);
            }
        }
    }
}

