package dev.mariany.genesisframework.mixin;

import dev.mariany.genesisframework.event.server.advancement.ServerAdvancementEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

@Mixin(class_2989.class)
public class ServerAdvancementLoaderMixin {
    /**
     * Invokes the {@link ServerAdvancementEvents#BEFORE_ADVANCEMENTS_LOAD} event during advancements load.
     */
    @Inject(
            at = @At("HEAD"),
            method = "apply(Ljava/util/Map;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)V"
    )
    protected void apply(
            Map<class_2960, class_161> map,
            class_3300 resourceManager,
            class_3695 profiler,
            CallbackInfo ci
    ) {
        ServerAdvancementEvents.BEFORE_ADVANCEMENTS_LOAD.invoker().onAdvancementsLoaded(map);
    }
}
