package dev.mariany.genesisframework.mixin;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeManager;
import dev.mariany.genesisframework.registry.GFRegistryKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

@Mixin(class_2168.class)
public class ServerCommandSourceMixin {
    @Inject(method = "listIdSuggestions", at = @At(value = "HEAD"), cancellable = true)
    public void injectListIdSuggestions(
            class_5321<? extends class_2378<?>> registryRef,
            class_2172.class_7078 suggestedIdType,
            SuggestionsBuilder builder,
            CommandContext<?> context,
            CallbackInfoReturnable<CompletableFuture<Suggestions>> cir
    ) {
        if (registryRef == GFRegistryKeys.AGE) {
            CompletableFuture<Suggestions> suggestions = class_2172.method_9257(
                    AgeManager.getInstance().getAges().stream().map(AgeEntry::getId),
                    builder
            );

            cir.setReturnValue(suggestions);
        }
    }
}
