package dev.mariany.genesisframework.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.mariany.genesisframework.age.AgeManager;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3441;
import net.minecraft.class_3955;
import net.minecraft.class_5321;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;

@Mixin(class_3244.class)
public class ServerPlayNetworkHandlerMixin {
    @Shadow
    public class_3222 player;

    /**
     * Check if an item is unlocked when calling {@link class_3441#method_64593(class_5321)}.
     */
    @WrapOperation(method = "onCraftRequest", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerRecipeBook;isUnlocked(Lnet/minecraft/registry/RegistryKey;)Z"))
    public boolean wrapOnCraftRequest(
            class_3441 recipeBook,
            class_5321<class_1860<?>> recipeKey,
            Operation<Boolean> original
    ) {
        MinecraftServer server = player.method_5682();

        if (server != null) {
            class_1863 recipeManager = server.method_3772();
            Optional<class_8786<?>> recipeEntry = recipeManager.method_8130(recipeKey);

            if (recipeEntry.isPresent()) {
                if (recipeEntry.get().comp_1933() instanceof class_3955 craftingRecipe) {
                    class_1799 stack = craftingRecipe.method_8116(class_9694.field_51631, server.method_30611());

                    if (!AgeManager.getInstance().isUnlocked(player, stack)) {
                        return false;
                    }
                }
            }
        }

        return original.call(recipeBook, recipeKey);
    }
}
