package dev.mariany.genesisframework.mixin;

import dev.mariany.genesisframework.advancement.criterion.GFCriteria;
import net.minecraft.class_2859;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;

@Mixin(class_3244.class)
public class ServerPlayerNetworkHandlerMixin {
    @Shadow
    public class_3222 player;

    /**
     * Triggers the {@link GFCriteria#OPEN_ADVANCEMENT_TAB} criteria when removing player from Trial Spawner state.
     */
    @Inject(method = "onAdvancementTab", at = @At(value = "TAIL"))
    public void injectOnAdvancementTab(class_2859 packet, CallbackInfo ci) {
        MinecraftServer server = player.method_5682();

        if (server != null) {
            if (packet.method_12415() == class_2859.class_2860.field_13024) {
                class_2960 advancementId = Objects.requireNonNull(packet.method_12416());
                class_8779 advancementEntry = server.method_3851().method_12896(advancementId);

                if (advancementEntry != null) {
                    GFCriteria.OPEN_ADVANCEMENT_TAB.trigger(player, advancementId);
                }
            }
        }
    }
}
