package dev.mariany.genesisframework.mixin;

import dev.mariany.genesisframework.age.AgeManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4861;
import net.minecraft.class_4862;
import net.minecraft.class_8047;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.class_9697;

@Mixin(class_4862.class)
public abstract class SmithingScreenHandlerMixin extends class_4861 {
    public SmithingScreenHandlerMixin(
            @Nullable class_3917<?> type,
            int syncId,
            class_1661 playerInventory,
            class_3914 context,
            class_8047 forgingSlotsManager
    ) {
        super(type, syncId, playerInventory, context, forgingSlotsManager);
    }

    @Shadow
    protected abstract class_9697 createRecipeInput();

    /**
     * Prevent crafting an item in a Smithing Table.
     */
    @Inject(method = "updateResult", at = @At(value = "HEAD"), cancellable = true)
    public void injectUpdateResult(CallbackInfo ci) {
        class_9697 smithingRecipeInput = this.createRecipeInput();

        if (this.field_22482 instanceof class_3222 serverPlayer) {
            class_3218 serverWorld = serverPlayer.method_51469();
            Optional<class_8786<class_8059>> optionalRecipeEntry = serverWorld.method_64577().method_8132(
                    class_3956.field_25388,
                    smithingRecipeInput,
                    serverWorld
            );

            optionalRecipeEntry.ifPresent(recipeEntry -> {
                        class_8059 recipe = recipeEntry.comp_1933();
                        class_1799 itemStack = recipe.method_8116(
                                smithingRecipeInput,
                                serverWorld.method_30349()
                        );

                        // Allows procedures like applying a smithing trim.
                        for (int i = 0; i < smithingRecipeInput.method_59983(); i++) {
                            if (smithingRecipeInput.method_59984(i).method_31574(itemStack.method_7909())) {
                                return;
                            }
                        }

                        if (!AgeManager.getInstance().isUnlocked(serverPlayer, itemStack)) {
                            ci.cancel();
                        }
                    }
            );
        }
    }
}
