package dev.mariany.genesisframework.mixin;

import dev.mariany.genesisframework.advancement.criterion.GFCriteria;
import dev.mariany.genesisframework.mixin.accessor.TrialSpawnerDataAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8963;
import net.minecraft.class_8966;
import net.minecraft.class_8967;

@Mixin(class_8967.class)
public class TrialSpawnerStateMixin {
    /**
     * Triggers the {@link GFCriteria#COMPLETE_TRIAL_SPAWNER_ADVANCEMENT} criteria when removing player from Trial Spawner state.
     */
    @Inject(
            method = "tick",
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/util/Set;remove(Ljava/lang/Object;)Z"
            )
    )
    private void onEjectReward(
            class_2338 pos, class_8963 logic, class_3218 world, CallbackInfoReturnable<class_8967> cir
    ) {
        class_8966 data = logic.method_55174();

        Set<UUID> players = ((TrialSpawnerDataAccessor) data).genesis$players();
        Iterator<UUID> iterator = players.iterator();

        if (iterator.hasNext()) {
            UUID uuid = iterator.next();
            boolean ominous = logic.method_58705();

            class_1657 player = world.method_18470(uuid);

            if (player instanceof class_3222 serverPlayer) {
                GFCriteria.COMPLETE_TRIAL_SPAWNER_ADVANCEMENT.trigger(serverPlayer, ominous);
            }
        }
    }
}
