package dev.mariany.genesisframework.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.mariany.genesisframework.advancement.AdvancementHelper;
import dev.mariany.genesisframework.age.Age;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.age.AgeManager;
import dev.mariany.genesisframework.age.AgeShareManager;
import dev.mariany.genesisframework.registry.GFRegistryKeys;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7079;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class AgeCommand {
    private static final DynamicCommandExceptionType AGE_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(
            id -> class_2561.method_54159("genesisframework.age.ageNotFound", id)
    );

    public static void register(
            CommandDispatcher<class_2168> dispatcher
    ) {
        dispatcher.register(
                class_2170.method_9247("age")
                        .requires(class_2170.method_71774(2))
                        .then(class_2170.method_9247("cache")
                                .then(class_2170.method_9247("clear")
                                        .then(class_2170.method_9247("global")
                                                .executes(
                                                        context ->
                                                                executeClearCache(
                                                                        context.getSource(), true
                                                                )
                                                )
                                        )
                                        .then(class_2170.method_9247("teams")
                                                .executes(
                                                        context ->
                                                                executeClearCache(
                                                                        context.getSource(), false
                                                                )
                                                )
                                        )
                                )
                        )
                        .then(class_2170.method_9247("give")
                                .then(class_2170.method_9244("targets", class_2186.method_9308()).then(
                                                class_2170.method_9244(
                                                                "age",
                                                                class_7079.method_41224(GFRegistryKeys.AGE)
                                                        )
                                                        .executes(context ->
                                                                executeGive(
                                                                        context.getSource(),
                                                                        class_2186.method_9312(
                                                                                context,
                                                                                "targets"
                                                                        ),
                                                                        getAgeEntry(context)
                                                                )
                                                        )
                                        )
                                )
                        )
                        .then(class_2170.method_9247("take")
                                .then(class_2170.method_9244("targets", class_2186.method_9308()).then(
                                                class_2170.method_9244(
                                                                "age",
                                                                class_7079.method_41224(GFRegistryKeys.AGE)
                                                        )
                                                        .executes(context ->
                                                                executeTake(
                                                                        context.getSource(),
                                                                        class_2186.method_9312(
                                                                                context,
                                                                                "targets"
                                                                        ),
                                                                        getAgeEntry(context)
                                                                )
                                                        )
                                        )
                                )
                        )
        );
    }

    private static int executeClearCache(class_2168 source, boolean global) {
        class_3218 world = source.method_9225();
        MinecraftServer server = world.method_8503();
        AgeShareManager ageShareManager = AgeShareManager.getServerState(server);

        int cleared = ageShareManager.clear(global);

        source.method_9226(
                () -> class_2561.method_43469("commands.genesisframework.age.clear", cleared),
                true
        );

        return 1;
    }

    private static int executeGive(class_2168 source, Collection<class_3222> targets, AgeEntry ageEntry) {
        int successCount = AgeShareManager.progressPlayersToAge(targets, ageEntry);

        source.method_9226(() -> class_2561.method_54159(
                        "commands.genesisframework.age.give.success",
                        ageEntry.getId(),
                        successCount
                ),
                true
        );

        return successCount;
    }

    private static int executeTake(class_2168 source, Collection<class_3222> targets, AgeEntry ageEntry) {
        int successCount = (int) targets.stream().filter(player -> takeAge(player, ageEntry)).count();

        source.method_9226(() -> class_2561.method_54159(
                        "commands.genesisframework.age.take.success",
                        ageEntry.getId(),
                        successCount
                ),
                true
        );

        return successCount;
    }

    private static boolean takeAge(class_3222 player, AgeEntry ageEntry) {
        class_8779 advancementEntry = ageEntry.getAdvancementEntry();
        boolean removed = AdvancementHelper.revokeAdvancement(player, advancementEntry);

        List<AgeEntry> children = AgeManager.getInstance().getAges().stream().filter(otherAge ->
                otherAge.getAge().parent()
                        .map(parentId -> parentId.equals(ageEntry.getId()))
                        .orElse(false)
        ).toList();

        for (AgeEntry child : children) {
            removed = takeAge(player, child) || removed;
        }

        return removed;
    }

    private static AgeEntry getAgeEntry(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_5321<Age> registryKey = class_7079.method_41220(
                context,
                "age",
                GFRegistryKeys.AGE,
                AGE_NOT_FOUND_EXCEPTION
        );
        Optional<AgeEntry> optionalAgeEntry = AgeManager.getInstance().get(registryKey.method_29177());

        if (optionalAgeEntry.isEmpty()) {
            throw AGE_NOT_FOUND_EXCEPTION.create(registryKey.method_29177());
        } else {
            return optionalAgeEntry.get();
        }
    }
}
