package dev.mariany.genesisframework.server.command;

import com.mojang.brigadier.CommandDispatcher;
import dev.mariany.genesisframework.advancement.AdvancementHelper;
import dev.mariany.genesisframework.instruction.InstructionEntry;
import dev.mariany.genesisframework.instruction.InstructionManager;
import java.util.Collection;
import java.util.function.BiFunction;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8779;

public class InstructionsCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
                class_2170.method_9247("instructions")
                        .then(class_2170.method_9247("restart")
                                .executes(context -> executeRestart(
                                                context.getSource()
                                        )
                                )
                        )
                        .then(class_2170.method_9247("skip")
                                .executes(context -> executeSkip(
                                                context.getSource()
                                        )
                                )
                        )
        );
    }

    private static int executeRestart(class_2168 source) {
        int processed = handleAdvancements(source, AdvancementHelper::revokeAdvancement);

        if (processed > 0) {
            source.method_9226(() -> class_2561.method_43469("commands.genesisframework.instructions.reset", processed), false);
        } else {
            source.method_9213(class_2561.method_43471("commands.genesisframework.instructions.reset.failure"));
        }

        return processed;
    }

    private static int executeSkip(class_2168 source) {
        int processed = handleAdvancements(source, AdvancementHelper::giveAdvancement);

        if (processed > 0) {
            source.method_9226(() -> class_2561.method_43469("commands.genesisframework.instructions.skip", processed), false);
        } else {
            source.method_9213(class_2561.method_43471("commands.genesisframework.instructions.skip.failure"));
        }

        return processed;
    }

    private static int handleAdvancements(
            class_2168 source,
            BiFunction<class_3222, class_8779, Boolean> consumer
    ) {
        int processed = 0;

        if (source.method_9228() instanceof class_3222 serverPlayer) {
            InstructionManager instructionManager = InstructionManager.getInstance();
            Collection<InstructionEntry> instructions = instructionManager.getInstructions();

            for (var instruction : instructions) {
                if (consumer.apply(serverPlayer, instruction.getAdvancementEntry())) {
                    ++processed;
                }
            }
        }

        return processed;
    }
}
