/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.sivage.image;

import dev.kleinbox.sivage.image.MapGenerationUtils;
import dev.kleinbox.sivage.item.ImageMetaData;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.server.MinecraftServer;

public class ImageProvider {
    public static Optional<BufferedImage> fetchImage(MinecraftServer server, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(server.method_36113());
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.connect();
        int status = connection.getResponseCode();
        if (status / 100 != 2) {
            return Optional.empty();
        }
        InputStream stream = connection.getInputStream();
        BufferedImage bufferedImage = ImageIO.read(stream);
        connection.disconnect();
        return Optional.of(bufferedImage);
    }

    public static Optional<byte[][]> ruinImage(BufferedImage image, int width, int height, ImageMetaData metadata) {
        int border = metadata.transparent() ? 0 : 8;
        int w = 128 * width - border * 2;
        int h = 128 * height - border * 2;
        if (!metadata.stretch()) {
            if (width > height && image.getWidth() > image.getHeight()) {
                h = -1;
            } else {
                w = -1;
            }
        }
        Image scaledInstance = image.getScaledInstance(w, h, 2);
        BufferedImage scaled = ImageProvider.toBufferedImage(scaledInstance, border, border, width * 128, height * 128, metadata.transparent());
        MapGenerationUtils.DitherType dither = metadata.dithering() ? MapGenerationUtils.DitherType.FLOYDSTEINBERG : MapGenerationUtils.DitherType.NONE;
        byte[][] result = MapGenerationUtils.imageToMinecraftMapColors(scaled, dither);
        int imgH = scaled.getHeight();
        int imgW = scaled.getWidth();
        for (int y = 0; y < imgH; ++y) {
            for (int x = 0; x < imgW; ++x) {
                boolean isBorder;
                int rgb = scaled.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                boolean bl = isBorder = x < border || x > imgW - border - 1 || y < border || y > imgH - border - 1;
                if ((alpha >= 128 || !metadata.transparent()) && (!isBorder || metadata.transparent())) continue;
                result[y][x] = 0;
            }
        }
        return Optional.of(result);
    }

    private static BufferedImage toBufferedImage(Image image, int offX, int offY, int width, int height, boolean transparent) {
        BufferedImage buffered = new BufferedImage(width, height, 2);
        Graphics2D bGr = buffered.createGraphics();
        if (transparent) {
            Composite previous = bGr.getComposite();
            bGr.setComposite(AlphaComposite.Clear);
            bGr.fillRect(0, 0, width, height);
            bGr.setComposite(previous);
        }
        bGr.drawImage(image, offX, offY, null);
        bGr.dispose();
        return buffered;
    }
}

