/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.sivage.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.kleinbox.sivage.Sivage;
import dev.kleinbox.sivage.image.ImageProvider;
import dev.kleinbox.sivage.item.ImageMetaData;
import dev.kleinbox.sivage.packet.ImageDialogs;
import dev.kleinbox.sivage.packet.LinkVerifier;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9209;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ImageItem {
    public static final class_2960 PAYLOAD_ID = Sivage.of("new");
    public static final String FRAME_TAG = Sivage.of("frame").toString();

    public static boolean isItem(class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        @Nullable class_9279 customData = (class_9279)itemInHand.method_57353().method_58694(class_9334.field_49628);
        if (!itemInHand.method_31574(class_1802.field_8892) || customData == null || itemInHand.method_7947() < 1) {
            return false;
        }
        class_2487 compoundTag = customData.method_57461();
        return compoundTag.method_10577("custom_image").orElse(false);
    }

    public static class_1269 onUse(class_1657 player, class_1937 level, class_1268 hand, class_3965 blockHitResult) {
        @Nullable MinecraftServer server = level.method_8503();
        if (server == null || level.method_8608() || player.method_7325()) {
            return class_1269.field_5811;
        }
        if (!ImageItem.isItem(player, hand)) {
            return class_1269.field_5811;
        }
        ImageDialogs.NEW.open((class_3218)level, (class_3222)player);
        return class_1269.field_5812;
    }

    public static boolean onPlace(class_2960 id, class_2520 payload, class_3222 player) {
        double reach;
        class_239 hitResult;
        DataResult result = ImageMetaData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)payload);
        if (!id.equals((Object)PAYLOAD_ID) || !result.isSuccess()) {
            return false;
        }
        ImageMetaData metadata = (ImageMetaData)result.getOrThrow();
        class_3218 level = player.method_51469();
        class_1799 consumed = class_1799.field_8037;
        if (!player.method_68878()) {
            for (class_1268 hand : class_1268.values()) {
                if (!ImageItem.isItem((class_1657)player, hand)) continue;
                class_1799 handItem = player.method_6047();
                consumed = handItem.method_7972();
                consumed.method_7939(1);
                handItem.method_57008(1, null);
                break;
            }
            if (consumed.method_7960()) {
                ImageDialogs.close(player);
                return false;
            }
        }
        if ((hitResult = player.method_5745(reach = player.method_6127().method_26852(class_5134.field_47758), 0.0f, false)).method_17783() != class_239.class_240.field_1332) {
            ImageDialogs.close(player);
            return false;
        }
        class_3965 blockHitResult = (class_3965)hitResult;
        class_1799 deposit = consumed;
        CompletableFuture.runAsync(() -> ImageItem.imagePlaceTask(metadata, level, player, blockHitResult, deposit), (Executor)class_156.method_18349());
        return true;
    }

    private static void imagePlaceTask(ImageMetaData metadata, class_3218 level, class_3222 player, class_3965 blockHitResult, class_1799 consumed) {
        Optional<BufferedImage> result;
        class_2350 dir = blockHitResult.method_17780();
        class_2338 blockPos = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
        MinecraftServer server = level.method_8503();
        ImageDialogs.PREPARE.open(level, player);
        Optional<URL> result2 = LinkVerifier.fromString(metadata.url());
        if (result2.isEmpty()) {
            ImageDialogs.FAILED_LINK.open(level, player);
            if (!player.method_7270(consumed)) {
                player.method_7328(consumed, false);
            }
            return;
        }
        URL url = result2.get();
        try {
            result = ImageProvider.fetchImage(server, url);
        }
        catch (IOException e) {
            result = Optional.empty();
        }
        Optional<Object> ruined = Optional.empty();
        if (result.isPresent()) {
            ruined = ImageProvider.ruinImage(result.get(), (int)metadata.width(), (int)metadata.height(), metadata);
        }
        if (result.isEmpty() || ruined.isEmpty()) {
            ImageDialogs.FAILED_FILE.open(level, player);
            if (!player.method_7270(consumed)) {
                player.method_7328(consumed, false);
            }
            return;
        }
        byte[][] image = (byte[][])ruined.get();
        ImageDialogs.close(player);
        level.method_8503().execute(() -> ImageItem.placeWholeImage((class_1657)player, level, blockHitResult, image, metadata));
    }

    private static void placeWholeImage(class_1657 player, class_3218 level, class_3965 blockHitResult, byte[][] image, ImageMetaData metadata) {
        class_2350 facing = blockHitResult.method_17780();
        class_2338 pos = blockHitResult.method_17777().method_10093(facing);
        class_1799[][] maps = ImageItem.imageToMaps(level, image, metadata.transparent());
        int width = maps[0].length;
        int height = maps.length;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                class_2338 curPos = ImageItem.offsetOnPainting(pos, facing, -x, -y);
                class_1533 itemFrame = new class_1533((class_1937)level, curPos, facing);
                itemFrame.field_22476 = true;
                itemFrame.method_5648(metadata.transparent());
                itemFrame.method_5780(FRAME_TAG);
                itemFrame.method_6935(maps[y][x]);
                level.method_43275((class_1297)player, (class_6880)class_5712.field_28738, itemFrame.method_73189());
                level.method_8649((class_1297)itemFrame);
            }
        }
    }

    private static class_2338 offsetOnPainting(class_2338 origin, class_2350 dir, int offX, int offY) {
        class_2350 upDir;
        class_2350 rightDir;
        if (dir.method_10166().method_10179()) {
            rightDir = dir.method_10170();
            upDir = class_2350.field_11036;
        } else {
            rightDir = class_2350.field_11034;
            upDir = dir == class_2350.field_11036 ? class_2350.field_11035 : class_2350.field_11043;
        }
        return origin.method_10069(rightDir.method_10148() * offX + upDir.method_10148() * offY, rightDir.method_10164() * offX + upDir.method_10164() * offY, rightDir.method_10165() * offX + upDir.method_10165() * offY);
    }

    private static class_1799[][] imageToMaps(class_3218 level, byte[][] image, boolean transparent) {
        int width = image[0].length;
        int height = image.length;
        int mapsW = (int)Math.ceil((double)width / 128.0);
        int mapsH = (int)Math.ceil((double)height / 128.0);
        class_1799[][] maps = new class_1799[mapsH][mapsW];
        for (int mapY = 0; mapY < mapsH; ++mapY) {
            for (int mapX = 0; mapX < mapsW; ++mapX) {
                class_9209 id = level.method_17889();
                class_22 map = new class_22(0, 0, 1, false, false, true, level.method_27983());
                int startX = mapX * 128;
                int startY = mapY * 128;
                for (int y = 0; y < 128; ++y) {
                    for (int x = 0; x < 128; ++x) {
                        map.method_32370(x, y, image[startY + y][startX + x]);
                    }
                }
                level.method_17890(id, map);
                class_1799 itemStack = new class_1799((class_1935)class_1802.field_8204);
                itemStack.method_57379(class_9334.field_49646, (Object)id);
                maps[mapY][mapX] = itemStack;
            }
        }
        return maps;
    }
}

