/*
 * Decompiled with CFR 0.152.
 */
package dev.kleinbox.sivage.packet;

import dev.kleinbox.sivage.Sivage;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueList;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Optional;

public class LinkVerifier {
    public static Optional<URL> fromString(String address) {
        URI uri;
        try {
            uri = new URI(address);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return LinkVerifier.fromURI(uri);
    }

    public static Optional<URL> fromURI(URI uri) {
        URL url;
        if (!LinkVerifier.isSafe(uri) || !LinkVerifier.hasRulesEnsured(uri)) {
            return Optional.empty();
        }
        if (uri.getHost() == null) {
            return Optional.empty();
        }
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
        return Optional.of(url);
    }

    private static boolean isSafe(URI uri) {
        if (uri.getScheme() == null) {
            return false;
        }
        String scheme = uri.getScheme().toLowerCase(Locale.ROOT);
        if (!scheme.equals("http") && !scheme.equals("https")) {
            return false;
        }
        return uri.getHost().chars().anyMatch(Character::isLetter);
    }

    private static boolean hasRulesEnsured(URI uri) {
        String host = uri.getHost();
        for (String rule : (ValueList)Sivage.CONFIG.whitelist.value()) {
            if (!LinkVerifier.matches(host, rule)) continue;
            return true;
        }
        for (String rule : (ValueList)Sivage.CONFIG.blacklist.value()) {
            if (!LinkVerifier.matches(host, rule)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(String host, String rule) {
        if (rule.contains("*")) {
            if (rule.equals("*")) {
                return true;
            }
            if (rule.startsWith("*.")) {
                String ruleDomain = rule.substring(2);
                if (host.endsWith(ruleDomain)) {
                    String hostWithoutRule = host.substring(0, host.length() - ruleDomain.length() - 1);
                    return !hostWithoutRule.contains(".");
                }
                return false;
            }
        }
        return host.equals(rule);
    }
}

