/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.village;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class VillageBuilding {
    private final ResourceLocation nbtPath;
    private final Set<ResourceLocation> villageTypes;
    private final int minCount;
    private final int maxCount;

    public VillageBuilding(ResourceLocation nbtPath, Set<ResourceLocation> villageTypes, int minCount, int maxCount) {
        if (nbtPath == null) {
            throw new IllegalArgumentException("NBT path cannot be null.");
        }
        if (minCount < 0 || maxCount < 0 || minCount > maxCount) {
            throw new IllegalArgumentException("Invalid min/max count. Must be non-negative and minCount <= maxCount.");
        }
        this.nbtPath = nbtPath;
        this.villageTypes = villageTypes != null ? Collections.unmodifiableSet(new HashSet<ResourceLocation>(villageTypes)) : Collections.emptySet();
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public ResourceLocation getNbtPath() {
        return this.nbtPath;
    }

    public Set<ResourceLocation> getVillageTypes() {
        return this.villageTypes;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

