/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.village;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.mint_gaming_studios.mint_lib.village.VillageBuilding;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillageBuildingManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<VillageBuilding> REGISTERED_BUILDINGS = new ArrayList<VillageBuilding>();

    public static void registerBuilding(VillageBuilding building) {
        if (building != null) {
            REGISTERED_BUILDINGS.add(building);
        }
    }

    public static void initialize() {
        MinecraftForge.EVENT_BUS.addListener(VillageBuildingManager::onServerAboutToStart);
    }

    private static void onServerAboutToStart(ServerAboutToStartEvent event) {
        if (REGISTERED_BUILDINGS.isEmpty()) {
            return;
        }
        LOGGER.info("MINT Lib: Attempting to inject {} custom village buildings...", (Object)REGISTERED_BUILDINGS.size());
        MinecraftServer server = event.getServer();
        Registry poolRegistry = server.m_206579_().m_175515_(Registries.f_256948_);
        Map<ResourceKey<StructureTemplatePool>, Holder.Reference<StructureTemplatePool>> rawPools = VillageBuildingManager.getRawRegistryMap((Registry<StructureTemplatePool>)poolRegistry);
        if (rawPools == null) {
            LOGGER.error("MINT Lib: Failed to get raw registry map. Cannot inject village buildings.");
            return;
        }
        Set villageHousePools = poolRegistry.m_6579_().stream().map(Map.Entry::getKey).filter(key -> {
            ResourceLocation loc = key.m_135782_();
            return loc.m_135827_().equals("minecraft") && loc.m_135815_().startsWith("village/") && loc.m_135815_().endsWith("_houses");
        }).collect(Collectors.toSet());
        for (VillageBuilding building : REGISTERED_BUILDINGS) {
            for (ResourceKey poolKey : villageHousePools) {
                boolean matches;
                if (!building.getVillageTypes().isEmpty() && !(matches = building.getVillageTypes().stream().anyMatch(type -> poolKey.m_135782_().m_135815_().startsWith(type.m_135815_())))) continue;
                LOGGER.debug("MINT Lib: Injecting '{}' into pool '{}'", (Object)building.getNbtPath(), (Object)poolKey.m_135782_());
                VillageBuildingManager.injectBuildingIntoPool(server, (Registry<StructureTemplatePool>)poolRegistry, rawPools, (ResourceKey<StructureTemplatePool>)poolKey, building);
            }
        }
        LOGGER.info("MINT Lib: Finished injecting custom village buildings.");
    }

    private static Map<ResourceKey<StructureTemplatePool>, Holder.Reference<StructureTemplatePool>> getRawRegistryMap(Registry<StructureTemplatePool> registry) {
        return registry.m_6579_().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Holder.Reference)registry.m_203636_((ResourceKey)entry.getKey()).orElseThrow(() -> new IllegalStateException("Missing holder for " + String.valueOf(entry.getKey())))));
    }

    private static void injectBuildingIntoPool(MinecraftServer server, Registry<StructureTemplatePool> poolRegistry, Map<ResourceKey<StructureTemplatePool>, Holder.Reference<StructureTemplatePool>> rawPools, ResourceKey<StructureTemplatePool> poolKey, VillageBuilding building) {
        List originalElements;
        Holder.Reference poolHolder = poolRegistry.m_246971_(poolKey);
        StructureTemplatePool originalPool = (StructureTemplatePool)poolHolder.m_203334_();
        try {
            Field elementsField = StructureTemplatePool.class.getDeclaredField("elements");
            elementsField.setAccessible(true);
            originalElements = (List)elementsField.get(originalPool);
        }
        catch (NoSuchFieldException e) {
            try {
                Field rawTemplatesField = StructureTemplatePool.class.getDeclaredField("rawTemplates");
                rawTemplatesField.setAccessible(true);
                originalElements = (List)rawTemplatesField.get(originalPool);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                LOGGER.error("MINT Lib: Reflection error accessing 'elements' or 'rawTemplates' field for pool {}. This is likely a Minecraft/Forge update issue.", (Object)poolKey.m_135782_(), (Object)ex);
                return;
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("MINT Lib: Reflection error accessing 'elements' field for pool {}.", (Object)poolKey.m_135782_(), (Object)e);
            return;
        }
        Holder fallback = originalPool.m_254935_();
        if (originalElements.isEmpty()) {
            return;
        }
        Registry processorRegistry = server.m_206579_().m_175515_(Registries.f_257011_);
        ResourceKey emptyProcessorKey = ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)new ResourceLocation("minecraft", "empty"));
        Holder.Reference emptyProcessorList = processorRegistry.m_246971_(emptyProcessorKey);
        StructurePoolElement newElement = (StructurePoolElement)SinglePoolElement.m_210531_((String)building.getNbtPath().toString(), (Holder)emptyProcessorList).apply(StructureTemplatePool.Projection.RIGID);
        ArrayList<Pair> newRawTemplates = new ArrayList<Pair>(originalElements);
        newRawTemplates.add(Pair.of((Object)newElement, (Object)1));
        StructureTemplatePool newPool = new StructureTemplatePool(fallback, newRawTemplates);
        Holder.Reference newHolder = Holder.Reference.m_254896_((HolderOwner)poolRegistry.m_255331_(), poolKey);
        newHolder.m_247654_((Object)newPool);
        rawPools.put(poolKey, (Holder.Reference<StructureTemplatePool>)newHolder);
    }
}

