/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.fish;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class FishData {
    private static final Random random = new Random();
    private static final Map<String, FishGroup> fishGroupMap = new HashMap<String, FishGroup>();
    private static final Map<ResourceLocation, FishGroup> registeredModFish = new HashMap<ResourceLocation, FishGroup>();

    public static void registerModFish(Supplier<? extends Item> fishItemSupplier, FishGroup group) {
        registeredModFish.put(ForgeRegistries.ITEMS.getKey((Object)fishItemSupplier.get()), group);
    }

    public static FishGroup getFishGroup(Item item) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
        if (registryName == null) {
            return FishGroup.MEDIUM_FISH;
        }
        if (registeredModFish.containsKey(registryName)) {
            return registeredModFish.get(registryName);
        }
        if (item == Items.f_42526_ || item == Items.f_42527_) {
            return FishGroup.MEDIUM_FISH;
        }
        if (item == Items.f_42528_ || item == Items.f_42529_) {
            return FishGroup.SMALL_FISH;
        }
        String path = registryName.m_135815_();
        for (Map.Entry<String, FishGroup> entry : fishGroupMap.entrySet()) {
            if (!path.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        if (path.contains("giant") || path.contains("whale") || path.contains("shark")) {
            return FishGroup.GIANT_FISH;
        }
        if (path.contains("large")) {
            return FishGroup.LARGE_FISH;
        }
        if (path.contains("tiny") || path.contains("minnow")) {
            return FishGroup.TINY_FISH;
        }
        int hashCode = registryName.toString().hashCode();
        FishGroup[] groups = new FishGroup[]{FishGroup.TINY_FISH, FishGroup.SMALL_FISH, FishGroup.MEDIUM_FISH, FishGroup.LARGE_FISH, FishGroup.VERY_LARGE_FISH};
        int index = Math.abs(hashCode) % groups.length;
        return groups[index];
    }

    public static FishProperties generateFishProperties(Item item, Player player) {
        return FishData.generateForGroup(FishData.getFishGroup(item), item, player);
    }

    private static FishProperties generateForGroup(FishGroup group, Item fishItem, Player player) {
        int luckOfTheSeaLevel = 0;
        if (player != null) {
            luckOfTheSeaLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44953_, (LivingEntity)player);
        }
        double basePercentile = random.nextDouble();
        for (int i = 0; i < luckOfTheSeaLevel; ++i) {
            basePercentile = Math.max(basePercentile, random.nextDouble());
        }
        double sizePercentile = basePercentile;
        double weightPercentile = sizePercentile + (random.nextDouble() - 0.5) * 0.3;
        weightPercentile = Math.max(0.0, Math.min(1.0, weightPercentile));
        int size = group.minSize + (int)(sizePercentile * (double)(group.maxSize - group.minSize));
        int weight = group.minWeight + (int)(weightPercentile * (double)(group.maxWeight - group.minWeight));
        return new FishProperties(size, weight, fishItem, group);
    }

    public static ItemStack getRandomDropForFishGroup(FishGroup group) {
        ArrayList<ItemStack> possibleDrops = new ArrayList<ItemStack>();
        switch (group) {
            case TINY_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42499_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42401_, random.nextInt(2) + 1)));
                break;
            }
            case SMALL_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42526_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42527_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42499_, random.nextInt(3) + 1)));
                break;
            }
            case MEDIUM_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42530_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42531_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42715_), new ItemStack((ItemLike)Items.f_42695_, random.nextInt(2) + 1)));
                break;
            }
            case LARGE_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42530_, random.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42531_, random.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42715_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42696_, random.nextInt(2) + 1)));
                break;
            }
            case VERY_LARGE_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42715_, random.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42696_, random.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42716_), new ItemStack((ItemLike)Items.f_42415_)));
                break;
            }
            case GIANT_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42716_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42415_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42616_, random.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42690_)));
            }
        }
        if (possibleDrops.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)possibleDrops.get(random.nextInt(possibleDrops.size()));
    }

    static {
        fishGroupMap.put("anchovy", FishGroup.TINY_FISH);
        fishGroupMap.put("minnow", FishGroup.TINY_FISH);
        fishGroupMap.put("sardine", FishGroup.TINY_FISH);
        fishGroupMap.put("sprat", FishGroup.TINY_FISH);
        fishGroupMap.put("goby", FishGroup.TINY_FISH);
        fishGroupMap.put("shiner", FishGroup.TINY_FISH);
        fishGroupMap.put("dace", FishGroup.TINY_FISH);
        fishGroupMap.put("bleak", FishGroup.TINY_FISH);
        fishGroupMap.put("gudgeon", FishGroup.TINY_FISH);
        fishGroupMap.put("loach", FishGroup.TINY_FISH);
        fishGroupMap.put("killifish", FishGroup.TINY_FISH);
        fishGroupMap.put("guppy", FishGroup.TINY_FISH);
        fishGroupMap.put("tetra", FishGroup.TINY_FISH);
        fishGroupMap.put("danio", FishGroup.TINY_FISH);
        fishGroupMap.put("rasbora", FishGroup.TINY_FISH);
        fishGroupMap.put("barb", FishGroup.TINY_FISH);
        fishGroupMap.put("smelt", FishGroup.TINY_FISH);
        fishGroupMap.put("capelin", FishGroup.TINY_FISH);
        fishGroupMap.put("silverside", FishGroup.TINY_FISH);
        fishGroupMap.put("stickleback", FishGroup.TINY_FISH);
        fishGroupMap.put("neon_tetra", FishGroup.TINY_FISH);
        fishGroupMap.put("cardinal_tetra", FishGroup.TINY_FISH);
        fishGroupMap.put("rummy_nose_tetra", FishGroup.TINY_FISH);
        fishGroupMap.put("ember_tetra", FishGroup.TINY_FISH);
        fishGroupMap.put("celestial_pearl_danio", FishGroup.TINY_FISH);
        fishGroupMap.put("zebra_danio", FishGroup.TINY_FISH);
        fishGroupMap.put("white_cloud_mountain_minnow", FishGroup.TINY_FISH);
        fishGroupMap.put("pygmy_corydoras", FishGroup.TINY_FISH);
        fishGroupMap.put("otocinclus", FishGroup.TINY_FISH);
        fishGroupMap.put("bristlenose_pleco", FishGroup.TINY_FISH);
        fishGroupMap.put("clown_killifish", FishGroup.TINY_FISH);
        fishGroupMap.put("gardner's_killifish", FishGroup.TINY_FISH);
        fishGroupMap.put("lampeye_killifish", FishGroup.TINY_FISH);
        fishGroupMap.put("endler's_livebearer", FishGroup.TINY_FISH);
        fishGroupMap.put("mosquito_fish", FishGroup.TINY_FISH);
        fishGroupMap.put("least_killifish", FishGroup.TINY_FISH);
        fishGroupMap.put("three_spined_stickleback", FishGroup.TINY_FISH);
        fishGroupMap.put("nine_spined_stickleback", FishGroup.TINY_FISH);
        fishGroupMap.put("glassfish", FishGroup.TINY_FISH);
        fishGroupMap.put("mudskipper", FishGroup.TINY_FISH);
        fishGroupMap.put("tropical_fish", FishGroup.SMALL_FISH);
        fishGroupMap.put("pufferfish", FishGroup.SMALL_FISH);
        fishGroupMap.put("herring", FishGroup.SMALL_FISH);
        fishGroupMap.put("mackerel", FishGroup.SMALL_FISH);
        fishGroupMap.put("perch", FishGroup.SMALL_FISH);
        fishGroupMap.put("trout", FishGroup.SMALL_FISH);
        fishGroupMap.put("crappie", FishGroup.SMALL_FISH);
        fishGroupMap.put("bluegill", FishGroup.SMALL_FISH);
        fishGroupMap.put("sunfish", FishGroup.SMALL_FISH);
        fishGroupMap.put("rock_bass", FishGroup.SMALL_FISH);
        fishGroupMap.put("tilapia", FishGroup.SMALL_FISH);
        fishGroupMap.put("bream", FishGroup.SMALL_FISH);
        fishGroupMap.put("roach", FishGroup.SMALL_FISH);
        fishGroupMap.put("chub", FishGroup.SMALL_FISH);
        fishGroupMap.put("grayling", FishGroup.SMALL_FISH);
        fishGroupMap.put("char", FishGroup.SMALL_FISH);
        fishGroupMap.put("flounder", FishGroup.SMALL_FISH);
        fishGroupMap.put("sole", FishGroup.SMALL_FISH);
        fishGroupMap.put("whiting", FishGroup.SMALL_FISH);
        fishGroupMap.put("haddock", FishGroup.SMALL_FISH);
        fishGroupMap.put("rainbow_trout", FishGroup.SMALL_FISH);
        fishGroupMap.put("brown_trout", FishGroup.SMALL_FISH);
        fishGroupMap.put("brook_trout", FishGroup.SMALL_FISH);
        fishGroupMap.put("lake_trout", FishGroup.SMALL_FISH);
        fishGroupMap.put("arctic_char", FishGroup.SMALL_FISH);
        fishGroupMap.put("dolly_varden", FishGroup.SMALL_FISH);
        fishGroupMap.put("whitefish", FishGroup.SMALL_FISH);
        fishGroupMap.put("cisco", FishGroup.SMALL_FISH);
        fishGroupMap.put("yellow_perch", FishGroup.SMALL_FISH);
        fishGroupMap.put("european_perch", FishGroup.SMALL_FISH);
        fishGroupMap.put("ruffe", FishGroup.SMALL_FISH);
        fishGroupMap.put("zope", FishGroup.SMALL_FISH);
        fishGroupMap.put("ide", FishGroup.SMALL_FISH);
        fishGroupMap.put("tench", FishGroup.SMALL_FISH);
        fishGroupMap.put("crucian_carp", FishGroup.SMALL_FISH);
        fishGroupMap.put("common_bream", FishGroup.SMALL_FISH);
        fishGroupMap.put("silver_bream", FishGroup.SMALL_FISH);
        fishGroupMap.put("white_bream", FishGroup.SMALL_FISH);
        fishGroupMap.put("vimba_bream", FishGroup.SMALL_FISH);
        fishGroupMap.put("nase", FishGroup.SMALL_FISH);
        fishGroupMap.put("plaice", FishGroup.SMALL_FISH);
        fishGroupMap.put("dab", FishGroup.SMALL_FISH);
        fishGroupMap.put("turbot", FishGroup.SMALL_FISH);
        fishGroupMap.put("brill", FishGroup.SMALL_FISH);
        fishGroupMap.put("megrim", FishGroup.SMALL_FISH);
        fishGroupMap.put("lemon_sole", FishGroup.SMALL_FISH);
        fishGroupMap.put("sand_dab", FishGroup.SMALL_FISH);
        fishGroupMap.put("european_eel", FishGroup.SMALL_FISH);
        fishGroupMap.put("american_eel", FishGroup.SMALL_FISH);
        fishGroupMap.put("conger_eel", FishGroup.SMALL_FISH);
        fishGroupMap.put("moray_eel", FishGroup.SMALL_FISH);
        fishGroupMap.put("scorpionfish", FishGroup.SMALL_FISH);
        fishGroupMap.put("lionfish", FishGroup.SMALL_FISH);
        fishGroupMap.put("stonefish", FishGroup.SMALL_FISH);
        fishGroupMap.put("lumpsucker", FishGroup.SMALL_FISH);
        fishGroupMap.put("sculpin", FishGroup.SMALL_FISH);
        fishGroupMap.put("blenny", FishGroup.SMALL_FISH);
        fishGroupMap.put("wrasse", FishGroup.SMALL_FISH);
        fishGroupMap.put("damselfish", FishGroup.SMALL_FISH);
        fishGroupMap.put("cod", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("salmon", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("bass", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("catfish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("pike", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("walleye", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("muskellunge", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("zander", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("barramundi", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("snapper", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("drum", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("bonefish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("bonito", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("bluefish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("snook", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("pollock", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("atlantic_cod", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("pacific_cod", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("greenland_cod", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("chinook_salmon", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("coho_salmon", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("sockeye_salmon", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("pink_salmon", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("chum_salmon", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("largemouth_bass", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("smallmouth_bass", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("striped_bass", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("white_bass", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("common_carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("mirror_carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("leather_carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("grass_carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("bighead_carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("silver_carp", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("channel_catfish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("blue_catfish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("flathead_catfish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("northern_pike", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("tiger_muskie", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("chain_pickerel", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("redfin_pickerel", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("red_drum", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("black_drum", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("sheepshead", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("permit", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("pompano", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("little_tunny", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("skipjack_tuna", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("dogfish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("hake", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("ling", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("saithe", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("coalfish", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("wolf_eel", FishGroup.MEDIUM_FISH);
        fishGroupMap.put("grouper", FishGroup.LARGE_FISH);
        fishGroupMap.put("cobia", FishGroup.LARGE_FISH);
        fishGroupMap.put("trevally", FishGroup.LARGE_FISH);
        fishGroupMap.put("yellowfin_tuna", FishGroup.LARGE_FISH);
        fishGroupMap.put("dogtooth_tuna", FishGroup.LARGE_FISH);
        fishGroupMap.put("sailfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("tarpon", FishGroup.LARGE_FISH);
        fishGroupMap.put("wahoo", FishGroup.LARGE_FISH);
        fishGroupMap.put("amberjack", FishGroup.LARGE_FISH);
        fishGroupMap.put("giant_trevally", FishGroup.LARGE_FISH);
        fishGroupMap.put("kingfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("lingcod", FishGroup.LARGE_FISH);
        fishGroupMap.put("paddlefish", FishGroup.LARGE_FISH);
        fishGroupMap.put("alligator_gar", FishGroup.LARGE_FISH);
        fishGroupMap.put("arapaima", FishGroup.LARGE_FISH);
        fishGroupMap.put("atlantic_sturgeon", FishGroup.LARGE_FISH);
        fishGroupMap.put("lake_sturgeon", FishGroup.LARGE_FISH);
        fishGroupMap.put("green_sturgeon", FishGroup.LARGE_FISH);
        fishGroupMap.put("atlantic_sailfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("pacific_sailfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("indo-pacific_sailfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("atlantic_tarpon", FishGroup.LARGE_FISH);
        fishGroupMap.put("indo-pacific_tarpon", FishGroup.LARGE_FISH);
        fishGroupMap.put("king_mackerel", FishGroup.LARGE_FISH);
        fishGroupMap.put("spanish_mackerel", FishGroup.LARGE_FISH);
        fishGroupMap.put("cero_mackerel", FishGroup.LARGE_FISH);
        fishGroupMap.put("yellowtail_kingfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("california_yellowtail", FishGroup.LARGE_FISH);
        fishGroupMap.put("giant_barracuda", FishGroup.LARGE_FISH);
        fishGroupMap.put("great_barracuda", FishGroup.LARGE_FISH);
        fishGroupMap.put("blacktip_reef_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("whitetip_reef_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("nurse_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("leopard_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("sevengill_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("sixgill_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("sand_tiger_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("sandbar_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("dusky_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("spinner_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("lemon_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("blue_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("shortfin_mako_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("longfin_mako_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("porbeagle_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("salmon_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("silky_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("tope_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("school_shark", FishGroup.LARGE_FISH);
        fishGroupMap.put("smooth-hound", FishGroup.LARGE_FISH);
        fishGroupMap.put("spiny_dogfish", FishGroup.LARGE_FISH);
        fishGroupMap.put("tuna", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("mahi_mahi", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("sturgeon", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("halibut", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("giant_sea_bass", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("goliath_grouper", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("opah", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("atlantic_halibut", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("pacific_halibut", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("greenland_halibut", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("white_sturgeon", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("swordfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("marlin", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("bluefin_tuna", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("black_marlin", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("blue_marlin", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("white_marlin", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("tiger_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("hammerhead_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("mako_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("thresher_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("bull_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("manta_ray", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("oarfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("atlantic_bluefin_tuna", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("pacific_bluefin_tuna", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("southern_bluefin_tuna", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("indo-pacific_blue_marlin", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("striped_marlin", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("broadbill_swordfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("great_hammerhead_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("scalloped_hammerhead_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("smooth_hammerhead_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("common_thresher_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("bigeye_thresher_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("pelagic_thresher_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("giant_manta_ray", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("reef_manta_ray", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("giant_freshwater_stingray", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("mekong_giant_catfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("vundu_catfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("goonch_catfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("piraiba_catfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("laulao_catfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("greenland_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("pacific_sleeper_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("southern_sleeper_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("megamouth_shark", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("wels_catfish", FishGroup.VERY_LARGE_FISH);
        fishGroupMap.put("shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("whale", FishGroup.GIANT_FISH);
        fishGroupMap.put("beluga_sturgeon", FishGroup.GIANT_FISH);
        fishGroupMap.put("great_white_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("whale_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("basking_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("ocean_sunfish", FishGroup.GIANT_FISH);
        fishGroupMap.put("kaluga_sturgeon", FishGroup.GIANT_FISH);
        fishGroupMap.put("hausen", FishGroup.GIANT_FISH);
        fishGroupMap.put("ganges_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("speartooth_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("northern_river_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("bizant_river_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("irrawaddy_river_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("borneo_river_shark", FishGroup.GIANT_FISH);
        fishGroupMap.put("new_guinea_river_shark", FishGroup.GIANT_FISH);
    }

    public static enum FishGroup {
        TINY_FISH(5, 15, 10, 50),
        SMALL_FISH(15, 40, 50, 500),
        MEDIUM_FISH(40, 120, 500, 15000),
        LARGE_FISH(120, 300, 15000, 100000),
        VERY_LARGE_FISH(300, 600, 100000, 1500000),
        GIANT_FISH(600, 1880, 1500000, 42000000);

        private final int minSize;
        private final int maxSize;
        private final int minWeight;
        private final int maxWeight;

        private FishGroup(int minSize, int maxSize, int minWeight, int maxWeight) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.minWeight = minWeight;
            this.maxWeight = maxWeight;
        }

        public int getMinSize() {
            return this.minSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public int getMinWeight() {
            return this.minWeight;
        }

        public int getMaxWeight() {
            return this.maxWeight;
        }
    }

    public static class FishProperties {
        private final int size;
        private final int weight;
        private final Item fishItem;
        private final FishGroup group;

        public FishProperties(int size, int weight, Item fishItem, FishGroup group) {
            this.size = size;
            this.weight = weight;
            this.fishItem = fishItem;
            this.group = group;
        }

        public String getFormattedWeight() {
            if (this.weight >= 1000000) {
                return String.format("%.2f t", (double)this.weight / 1000000.0);
            }
            if (this.weight >= 1000) {
                return String.format("%.1f kg", (double)this.weight / 1000.0);
            }
            return String.format("%d g", this.weight);
        }

        public Rarity calculateRarity() {
            double weightPercentile = (double)(this.weight - this.group.minWeight) / (double)(this.group.maxWeight - this.group.minWeight) * 100.0;
            if (weightPercentile >= 95.0) {
                return Rarity.EPIC;
            }
            if (weightPercentile >= 80.0) {
                return Rarity.RARE;
            }
            if (weightPercentile >= 60.0) {
                return Rarity.UNCOMMON;
            }
            return Rarity.COMMON;
        }

        public void addTooltipInfo(List<Component> tooltip) {
            tooltip.add((Component)Component.m_237110_((String)"mint_lib.fish.tooltip.size", (Object[])new Object[]{this.getFormattedSize()}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"mint_lib.fish.tooltip.weight", (Object[])new Object[]{this.getFormattedWeight()}).m_130940_(ChatFormatting.GRAY));
        }

        public String getFormattedSize() {
            return String.format("%d cm", this.size);
        }

        public Item getFishItem() {
            return this.fishItem;
        }

        public int getSize() {
            return this.size;
        }

        public int getWeight() {
            return this.weight;
        }

        public FishGroup getGroup() {
            return this.group;
        }
    }
}

