/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.mint_lib.texture;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import net.mint_gaming_studios.mint_lib.texture.ITextureResourceLoader;

public class TextureGenerator {
    private final GenerationMode generationMode;
    private final Path outputDirectory;
    private final Path greyscaleTexture;
    private final ITextureResourceLoader resourceLoader;
    private Map<Integer, Path> customTextureMap;
    private String registryName;
    private TextureType textureType;
    private final Map<Integer, String> automatedTextureNameMap = new HashMap<Integer, String>();
    private final Map<Integer, BufferedImage> customTextureCache = new HashMap<Integer, BufferedImage>();
    private final Map<String, BufferedImage> automatedTextureCache = new HashMap<String, BufferedImage>();

    public TextureGenerator(GenerationMode generationMode, Path outputDirectory, Path greyscaleTexture, ITextureResourceLoader resourceLoader) {
        this.generationMode = generationMode;
        this.outputDirectory = outputDirectory;
        this.greyscaleTexture = greyscaleTexture;
        this.resourceLoader = resourceLoader;
    }

    public void setCustomTextureMap(Map<Integer, Path> customTextureMap) {
        if (this.generationMode != GenerationMode.CUSTOM) {
            throw new IllegalStateException("Cannot set custom texture map in non-CUSTOM mode.");
        }
        this.customTextureMap = customTextureMap;
    }

    public void setAutomatedModeInfo(String registryName, TextureType textureType) {
        if (this.generationMode != GenerationMode.AUTOMATED) {
            throw new IllegalStateException("Cannot set automated mode info in non-AUTOMATED mode.");
        }
        this.registryName = registryName;
        this.textureType = textureType;
    }

    public void generate() throws IOException {
        if (this.generationMode == GenerationMode.CUSTOM && (this.customTextureMap == null || this.customTextureMap.isEmpty())) {
            throw new IllegalStateException("Custom texture map must be set for CUSTOM generation mode.");
        }
        if (this.generationMode == GenerationMode.AUTOMATED && (this.registryName == null || this.textureType == null)) {
            throw new IllegalStateException("Registry name and texture type must be set for AUTOMATED generation mode.");
        }
        this.customTextureCache.clear();
        this.automatedTextureCache.clear();
        this.automatedTextureNameMap.clear();
        if (this.generationMode == GenerationMode.AUTOMATED) {
            this.parseRegistryName();
        }
        BufferedImage greyScaleImage = ImageIO.read(this.greyscaleTexture.toFile());
        int width = greyScaleImage.getWidth();
        int height = greyScaleImage.getHeight();
        BufferedImage outputImage = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Color color = new Color(greyScaleImage.getRGB(x, y), true);
                if (color.getAlpha() > 0) {
                    int red = color.getRed();
                    if (red > 0) {
                        int textureId = red / 10;
                        BufferedImage texture = this.getTexture(textureId);
                        if (texture != null) {
                            int textureX = x % texture.getWidth();
                            int textureY = y % texture.getHeight();
                            outputImage.setRGB(x, y, texture.getRGB(textureX, textureY));
                            continue;
                        }
                        outputImage.setRGB(x, y, greyScaleImage.getRGB(x, y));
                        continue;
                    }
                    outputImage.setRGB(x, y, greyScaleImage.getRGB(x, y));
                    continue;
                }
                outputImage.setRGB(x, y, 0);
            }
        }
        Files.createDirectories(this.outputDirectory, new FileAttribute[0]);
        String outputFileName = this.greyscaleTexture.getFileName().toString().replace(".png", "_generated.png");
        Path outputPath = this.outputDirectory.resolve(outputFileName);
        ImageIO.write((RenderedImage)outputImage, "PNG", outputPath.toFile());
        System.out.println("Successfully generated texture to: " + String.valueOf(outputPath));
    }

    private void parseRegistryName() throws IOException {
        String greyScaleName = this.greyscaleTexture.getFileName().toString().replace(".png", "");
        if (!this.registryName.startsWith(greyScaleName)) {
            throw new IllegalStateException("Registry name '" + this.registryName + "' does not start with the greyscale texture name '" + greyScaleName + "'.");
        }
        String textureNamesPart = this.registryName.substring(greyScaleName.length());
        if (textureNamesPart.startsWith("_")) {
            textureNamesPart = textureNamesPart.substring(1);
        }
        int currentTextureId = 1;
        String[] allSegments = textureNamesPart.split("_");
        int segmentIndex = 0;
        while (segmentIndex < allSegments.length) {
            String bestMatchForCurrentId = null;
            int bestMatchSegmentCount = 0;
            for (int i = segmentIndex; i < allSegments.length; ++i) {
                StringBuilder potentialNameBuilder = new StringBuilder();
                for (int j = segmentIndex; j <= i; ++j) {
                    potentialNameBuilder.append(allSegments[j]);
                    if (j >= i) continue;
                    potentialNameBuilder.append("_");
                }
                String potentialTextureName = potentialNameBuilder.toString();
                if (!this.doesTextureExist(potentialTextureName)) continue;
                bestMatchForCurrentId = potentialTextureName;
                bestMatchSegmentCount = i - segmentIndex + 1;
            }
            if (bestMatchForCurrentId != null) {
                this.automatedTextureNameMap.put(currentTextureId, bestMatchForCurrentId);
                ++currentTextureId;
                segmentIndex += bestMatchSegmentCount;
                continue;
            }
            String fallbackSegment = allSegments[segmentIndex];
            this.automatedTextureNameMap.put(currentTextureId, fallbackSegment);
            ++currentTextureId;
            ++segmentIndex;
            System.err.println("No valid texture name combination found for part of '" + textureNamesPart + "' starting at segment '" + fallbackSegment + "'. Using '" + fallbackSegment + "' as fallback.");
        }
    }

    private boolean doesTextureExist(String textureName) {
        boolean bl;
        block9: {
            if (this.resourceLoader == null) {
                return false;
            }
            String textureIdentifier = this.textureType.name().toLowerCase() + "/" + textureName;
            ResourceLocation modelLocation = new ResourceLocation("minecraft", textureIdentifier);
            ResourceLocation fileLocation = new ResourceLocation(modelLocation.m_135827_(), "textures/" + modelLocation.m_135815_() + ".png");
            InputStream is = this.resourceLoader.getResource(fileLocation);
            try {
                boolean bl2 = bl = is != null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("Error checking existence for texture: " + textureName + ". Error: " + e.getMessage());
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage getTexture(int textureId) throws IOException {
        if (this.generationMode == GenerationMode.CUSTOM) {
            if (this.customTextureCache.containsKey(textureId)) {
                return this.customTextureCache.get(textureId);
            }
            Path texturePath = this.customTextureMap.get(textureId);
            if (texturePath == null) return null;
            if (!Files.exists(texturePath, new LinkOption[0])) return null;
            BufferedImage image = ImageIO.read(texturePath.toFile());
            this.customTextureCache.put(textureId, image);
            return image;
        }
        String textureName = this.automatedTextureNameMap.get(textureId);
        if (textureName == null) {
            return null;
        }
        if (this.automatedTextureCache.containsKey(textureName)) {
            return this.automatedTextureCache.get(textureName);
        }
        if (this.resourceLoader == null) {
            System.err.println("Resource loader not available for AUTOMATED mode. Cannot load vanilla texture.");
            return null;
        }
        String textureIdentifier = this.textureType.name().toLowerCase() + "/" + textureName;
        ResourceLocation modelLocation = new ResourceLocation("minecraft", textureIdentifier);
        ResourceLocation fileLocation = new ResourceLocation(modelLocation.m_135827_(), "textures/" + modelLocation.m_135815_() + ".png");
        try (InputStream is = this.resourceLoader.getResource(fileLocation);){
            if (is == null) return null;
            BufferedImage image = ImageIO.read(is);
            this.automatedTextureCache.put(textureName, image);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (IOException e) {
            System.err.println("Could not find or load resource for: " + String.valueOf(modelLocation) + ". Error: " + e.getMessage());
            return null;
        }
    }

    public static enum GenerationMode {
        CUSTOM,
        AUTOMATED;

    }

    public static enum TextureType {
        BLOCK,
        ITEM,
        ENTITY;

    }
}

