/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.mixin;

import com.flechazo.oneenoughfluid.init.FluidReplacementCache;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FluidStack.class})
public abstract class FluidStackMixin {
    @Shadow(remap=false)
    @Mutable
    private Holder.Reference<Fluid> fluidDelegate;

    @Shadow(remap=false)
    public abstract Fluid getFluid();

    @Inject(method={"<init>(Lnet/minecraft/world/level/material/Fluid;I)V"}, at={@At(value="RETURN")}, remap=false)
    private void oef$replaceOnInit(Fluid fluid, int amount, CallbackInfo ci) {
        if (fluid == null || fluid == Fluids.f_76191_) {
            return;
        }
        if (ReplacementControl.shouldSkipReplacement()) {
            return;
        }
        try {
            ResourceLocation id = ForgeRegistries.FLUIDS.getKey((Object)fluid);
            if (id == null) {
                return;
            }
            String targetId = FluidReplacementCache.matchFluid(id.toString());
            if (targetId == null) {
                return;
            }
            Fluid target = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(targetId));
            if (target != null && target != Fluids.f_76191_) {
                this.fluidDelegate = ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)target);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"isFluidEqual(Lnet/minecraftforge/fluids/FluidStack;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void oef$extendEquality(FluidStack other, CallbackInfoReturnable<Boolean> cir) {
        Fluid self = this.getFluid();
        if (self == null) {
            return;
        }
        if (self == other.getFluid()) {
            return;
        }
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((Object)self);
        if (id == null) {
            return;
        }
        boolean matched = false;
        for (String matchId : FluidReplacementCache.trackSourceIdOf(id.toString())) {
            Fluid match = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(matchId));
            if (match == null || match != other.getFluid()) continue;
            matched = true;
            break;
        }
        if (matched) {
            cir.setReturnValue((Object)true);
        }
    }

    private static Item findBucketForFluid(Fluid f) {
        for (Item item : ForgeRegistries.ITEMS) {
            BucketItem bucket;
            if (!(item instanceof BucketItem) || (bucket = (BucketItem)item).getFluid() != f) continue;
            return item;
        }
        return null;
    }
}

