/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.api.adapter;

import com.flechazo.oneenoughfluid.api.adapter.ui.FluidReplacementUiAdapter;
import com.flechazo.oneenoughfluid.client.gui.FluidSelectionScreen;
import com.flechazo.oneenoughfluid.client.gui.FluidTagSelectionScreen;
import com.flechazo.oneenoughfluid.client.gui.cache.GlobalFluidReplacementCache;
import com.flechazo.oneenoughfluid.init.FluidReplacementCache;
import com.mafuyu404.oelib.forge.client.renderer.FluidRenderUtils;
import com.mafuyu404.oneenoughitem.api.DomainAdapter;
import com.mafuyu404.oneenoughitem.api.DomainRuntimeCache;
import com.mafuyu404.oneenoughitem.api.ReplacementUiAdapter;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.AbstractGlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidDomainAdapter
implements DomainAdapter {
    public String modId() {
        return "oneenoughfluid";
    }

    public String id() {
        return "oef";
    }

    public String dataId() {
        return "fluid";
    }

    public Component selectObjectLabel() {
        return Component.m_237115_((String)"gui.oneenoughfluid.add_fluid");
    }

    public Component selectTagLabel() {
        return Component.m_237115_((String)"gui.oneenoughfluid.add_fluid_tag");
    }

    public Screen createObjectSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        return new FluidSelectionScreen(parent, isForMatch);
    }

    public Screen createTagSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        return new FluidTagSelectionScreen(parent, isForMatch);
    }

    public boolean isAvailable() {
        return true;
    }

    public AbstractGlobalReplacementCache globalCache() {
        return GlobalFluidReplacementCache.get();
    }

    public DomainRuntimeCache runtimeCache() {
        return new DomainRuntimeCache(){

            public String matchData(String id) {
                return FluidReplacementCache.matchFluid(id);
            }

            public String matchTag(ResourceLocation tagId) {
                return FluidReplacementCache.matchTag(tagId);
            }

            public void removeReplacements(Collection<String> dataIds, Collection<String> tagIds) {
                FluidReplacementCache.removeReplacements(dataIds, tagIds);
            }

            public boolean isTagReplaced(String tagId) {
                return FluidReplacementCache.isTagReplaced(tagId);
            }

            public boolean isTagReplaced(ResourceLocation tagId) {
                return FluidReplacementCache.isTagReplaced(tagId);
            }
        };
    }

    public String dataIdFromItem(Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        FluidStack contained = (FluidStack)ReplacementControl.withSkipReplacement(() -> FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY));
        Fluid fluid = contained.getFluid();
        ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        return fluid != Fluids.f_76191_ && key != null ? key.toString() : null;
    }

    public ItemStack iconForDataId(String dataId) {
        Fluid fluid;
        ResourceLocation rl = ResourceLocation.m_135820_((String)dataId);
        Fluid fluid2 = fluid = rl != null ? (Fluid)ForgeRegistries.FLUIDS.getValue(rl) : null;
        if (fluid == null || fluid == Fluids.f_76191_) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)ReplacementControl.withSkipReplacement(() -> FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000)));
    }

    public void renderDataId(GuiGraphics graphics, String dataId, int x, int y) {
        Fluid fluid;
        GuiUtils.drawItemBox((GuiGraphics)graphics, (int)x, (int)y, (int)18, (int)18);
        ResourceLocation rl = ResourceLocation.m_135820_((String)dataId);
        Fluid fluid2 = fluid = rl != null ? (Fluid)ForgeRegistries.FLUIDS.getValue(rl) : null;
        if (fluid == null || fluid == Fluids.f_76191_) {
            return;
        }
        ReplacementControl.withSkipReplacement(() -> {
            FluidStack stack = new FluidStack(fluid, 1000);
            FluidRenderUtils.renderFluid((GuiGraphics)graphics, (FluidStack)stack, (int)(x + 1), (int)(y + 1), (int)16, (int)16);
        });
    }

    public Component displayName(String dataId) {
        Fluid fluid;
        ResourceLocation rl = ResourceLocation.m_135820_((String)dataId);
        Fluid fluid2 = fluid = rl != null ? (Fluid)ForgeRegistries.FLUIDS.getValue(rl) : null;
        if (fluid == null || fluid == Fluids.f_76191_) {
            return Component.m_237113_((String)dataId);
        }
        return (Component)ReplacementControl.withSkipReplacement(() -> {
            FluidStack fs = new FluidStack(fluid, 1000);
            return fs.getDisplayName();
        });
    }

    public ReplacementUiAdapter uiAdapter() {
        return new FluidReplacementUiAdapter(this.runtimeCache(), this.globalCache());
    }
}

