/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.client.gui;

import com.mafuyu404.oelib.forge.client.renderer.FluidRenderUtils;
import com.mafuyu404.oneenoughitem.client.gui.BaseObjectSelectionScreen;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidSelectionScreen
extends BaseObjectSelectionScreen<Fluid> {
    public FluidSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        super(parent, isForMatch, (Component)Component.m_237115_((String)"gui.oneenoughfluid.add_fluid"));
        this.allObjects = this.loadAllObjects();
        this.filteredObjects = new ArrayList(this.allObjects);
    }

    protected Component sortLabel() {
        return Component.m_237115_((String)"gui.oneenoughitem.sort.name");
    }

    protected List<Fluid> loadAllObjects() {
        return ForgeRegistries.FLUIDS.getValues().stream().filter(f -> f != Fluids.f_76191_).filter(f -> f.m_76145_().m_76170_()).collect(Collectors.toList());
    }

    protected String getId(Fluid obj) {
        ResourceLocation key = ForgeRegistries.FLUIDS.getKey((Object)obj);
        return key != null ? key.toString() : null;
    }

    protected void renderObject(Fluid obj, GuiGraphics graphics, int x, int y) {
        GuiUtils.drawItemBox((GuiGraphics)graphics, (int)x, (int)y, (int)18, (int)18);
        FluidStack stack = new FluidStack(obj, 1000);
        FluidRenderUtils.renderFluid((GuiGraphics)graphics, (FluidStack)stack, (int)(x + 1), (int)(y + 1), (int)16, (int)16);
    }

    protected void onSelectSingle(String id) {
        ResourceLocation key = ResourceLocation.m_135820_((String)id);
        Fluid fluid = key != null ? (Fluid)ForgeRegistries.FLUIDS.getValue(key) : null;
        String fluidId = null;
        if (fluid != null && fluid != Fluids.f_76191_) {
            fluidId = Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)fluid)).toString();
        } else {
            ResourceLocation fk;
            FluidStack contained;
            Item item;
            ResourceLocation itemKey = ResourceLocation.m_135820_((String)id);
            Item item2 = item = itemKey != null ? (Item)ForgeRegistries.ITEMS.getValue(itemKey) : null;
            if (item != null && !(contained = (FluidStack)ReplacementControl.withSkipReplacement(() -> FluidUtil.getFluidContained((ItemStack)new ItemStack((ItemLike)item)).orElse(FluidStack.EMPTY))).isEmpty() && contained.getFluid() != Fluids.f_76191_ && (fk = ForgeRegistries.FLUIDS.getKey((Object)contained.getFluid())) != null) {
                fluidId = fk.toString();
            }
        }
        if (fluidId == null) {
            return;
        }
        if (this.isForMatch) {
            this.parent.addMatchDataId(fluidId);
        } else {
            this.parent.setResultDataId(fluidId);
        }
    }

    protected boolean isSelectable(String id, boolean forMatch) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        Fluid fluid = rl != null ? (Fluid)ForgeRegistries.FLUIDS.getValue(rl) : null;
        return fluid != null && fluid != Fluids.f_76191_;
    }

    protected Comparator<Fluid> getComparator(BaseObjectSelectionScreen.SortMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case BaseObjectSelectionScreen.SortMode.NAME -> Comparator.comparing(f -> {
                ItemStack bucket = (ItemStack)ReplacementControl.withSkipReplacement(() -> FluidUtil.getFilledBucket((FluidStack)new FluidStack(f, 1000)));
                return bucket.m_41619_() ? ForgeRegistries.FLUIDS.getKey(f).toString() : bucket.m_41786_().getString();
            });
            case BaseObjectSelectionScreen.SortMode.MOD -> Comparator.comparing(f -> Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey(f)).m_135827_());
            case BaseObjectSelectionScreen.SortMode.ID -> Comparator.comparing(f -> Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey(f)).toString());
        };
    }

    protected void updateGrid() {
        if (this.itemGrid == null) {
            return;
        }
        ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
        int startIndex = this.currentPage * 45;
        int endIndex = Math.min(startIndex + 45, this.filteredObjects.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Fluid f = (Fluid)this.filteredObjects.get(i);
            ItemStack bucket = (ItemStack)ReplacementControl.withSkipReplacement(() -> FluidUtil.getFilledBucket((FluidStack)new FluidStack(f, 1000)));
            pageItems.add(bucket.m_41619_() ? ItemStack.f_41583_ : bucket);
        }
        this.itemGrid.setItems(pageItems);
        this.itemGrid.setSelectedItemIds(this.selectedIds);
    }
}

