/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.init;

import com.flechazo.oneenoughfluid.Oneenoughfluid;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;

public final class FluidReplacementCache {
    private static final ConcurrentHashMap<String, String> FluidMapCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> TagMapCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Replacements.Rules> FluidRulesCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Replacements.Rules> TagRulesCache = new ConcurrentHashMap();
    private static volatile Map<String, String> ReloadOverrideFluidMap = null;

    public static String matchFluid(String id) {
        return ((Map)Objects.requireNonNullElse(ReloadOverrideFluidMap, FluidMapCache)).getOrDefault(id, null);
    }

    public static String matchTag(String tagId) {
        return TagMapCache.getOrDefault(tagId, null);
    }

    public static String matchTag(ResourceLocation tagId) {
        return tagId != null ? FluidReplacementCache.matchTag(tagId.toString()) : null;
    }

    public static boolean isSourceFluidId(String id) {
        return id != null && ((Map)Objects.requireNonNullElse(ReloadOverrideFluidMap, FluidMapCache)).containsKey(id);
    }

    public static boolean isSourceTagId(String id) {
        return id != null && TagMapCache.containsKey(id);
    }

    public static boolean isTagReplaced(String tagId) {
        return tagId != null && TagMapCache.containsKey(tagId);
    }

    public static boolean isTagReplaced(ResourceLocation tagId) {
        return tagId != null && FluidReplacementCache.isTagReplaced(tagId.toString());
    }

    public static Optional<Replacements.Rules> getFluidRules(String itemId) {
        return Optional.ofNullable(FluidRulesCache.get(itemId));
    }

    public static Optional<Replacements.Rules> getTagRules(String tagId) {
        return Optional.ofNullable(TagRulesCache.get(tagId));
    }

    public static void clearCache() {
        FluidMapCache.clear();
        TagMapCache.clear();
        FluidRulesCache.clear();
        TagRulesCache.clear();
    }

    public static boolean hasAnyMappings() {
        return !FluidMapCache.isEmpty() || !TagMapCache.isEmpty();
    }

    public static void putReplacement(Replacements replacement) {
        String result = replacement.result();
        replacement.rules().ifPresentOrElse(rules -> {
            for (String m : replacement.match()) {
                if (m == null || m.isEmpty()) continue;
                if (m.startsWith("#")) {
                    String tagId = m.substring(1);
                    TagMapCache.put(tagId, result);
                    TagRulesCache.put(tagId, (Replacements.Rules)rules);
                    continue;
                }
                FluidMapCache.put(m, result);
                FluidRulesCache.put(m, (Replacements.Rules)rules);
            }
        }, () -> {
            for (String m : replacement.match()) {
                if (m == null || m.isEmpty()) continue;
                if (m.startsWith("#")) {
                    TagMapCache.put(m.substring(1), result);
                    continue;
                }
                FluidMapCache.put(m, result);
            }
        });
    }

    public static boolean removeFluidReplacement(String fluidId) {
        if (fluidId != null && FluidMapCache.containsKey(fluidId)) {
            String removed = FluidMapCache.remove(fluidId);
            FluidRulesCache.remove(fluidId);
            Oneenoughfluid.LOGGER.debug("Removed fluid replacement from runtime cache: {} -> {}", (Object)fluidId, (Object)removed);
            return true;
        }
        return false;
    }

    public static boolean removeTagReplacement(String tagId) {
        if (tagId != null && TagMapCache.containsKey(tagId)) {
            String removed = TagMapCache.remove(tagId);
            TagRulesCache.remove(tagId);
            Oneenoughfluid.LOGGER.debug("Removed tag replacement from runtime cache: {} -> {}", (Object)tagId, (Object)removed);
            return true;
        }
        return false;
    }

    public static void removeReplacements(Collection<String> fluidIds, Collection<String> tagIds) {
        boolean changed = false;
        if (fluidIds != null) {
            for (String fluidId : fluidIds) {
                if (!FluidReplacementCache.removeFluidReplacement(fluidId)) continue;
                changed = true;
            }
        }
        if (tagIds != null) {
            for (String tagId : tagIds) {
                if (!FluidReplacementCache.removeTagReplacement(tagId)) continue;
                changed = true;
            }
        }
        if (changed) {
            Oneenoughfluid.LOGGER.info("Removed {} fluid replacements and {} tag replacements from runtime cache", (Object)(fluidIds != null ? fluidIds.size() : 0), (Object)(tagIds != null ? tagIds.size() : 0));
        }
    }

    public static Collection<String> trackSourceIdOf(String id) {
        HashSet<String> result = new HashSet<String>();
        FluidMapCache.forEach((matchFluid, resultFluid) -> {
            if (resultFluid.equals(id)) {
                result.add((String)matchFluid);
            }
        });
        return result;
    }

    private static List<Fluid> resolve(List<String> ids) {
        ArrayList<Fluid> out = new ArrayList<Fluid>();
        for (String id : ids) {
            if (id == null || id.isEmpty()) continue;
            if (id.startsWith("#")) {
                ResourceLocation tagId = new ResourceLocation(id.substring(1));
                ITag tag = ForgeRegistries.FLUIDS.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.FLUIDS.getRegistryKey(), (ResourceLocation)tagId));
                out.addAll(tag.stream().toList());
                continue;
            }
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(id));
            if (fluid == null) continue;
            out.add(fluid);
        }
        return out;
    }

    private static Optional<Replacements.Rules> getGlobalDefaultRules() {
        try {
            DomainConfig.DefaultRules cfg = OEIConfig.getDefaultRules((String)"oef");
            if (cfg != null) {
                return Optional.of(cfg.toRules());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static boolean shouldReplaceInDataDir(String itemId, String directory) {
        return FluidReplacementCache.getFluidRules(itemId).or(FluidReplacementCache::getGlobalDefaultRules).flatMap(Replacements.Rules::data).map(dataRules -> (Replacements.ProcessingMode)dataRules.get(directory)).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
    }

    public static boolean shouldReplaceInTagType(String itemId, String tagType) {
        return FluidReplacementCache.getFluidRules(itemId).or(FluidReplacementCache::getGlobalDefaultRules).flatMap(Replacements.Rules::tag).map(tagRules -> (Replacements.ProcessingMode)tagRules.get(tagType)).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
    }

    public static void beginReloadOverride(Map<String, String> currentFluidMap) {
        if (currentFluidMap == null || currentFluidMap.isEmpty()) {
            ReloadOverrideFluidMap = null;
            return;
        }
        Oneenoughfluid.LOGGER.info("Enabled reload-override mapping for this resource reload: {} fluid", (Object)ReloadOverrideFluidMap.size());
        ReloadOverrideFluidMap = new HashMap<String, String>(currentFluidMap);
    }

    public static void endReloadOverride() {
        if (ReloadOverrideFluidMap != null) {
            Oneenoughfluid.LOGGER.info("Disabled reload-override mapping: {} entries", (Object)ReloadOverrideFluidMap.size());
        }
        ReloadOverrideFluidMap = null;
    }

    public static boolean hasReloadOverride() {
        return ReloadOverrideFluidMap != null;
    }
}

