/*
 * Decompiled with CFR 0.152.
 */
package com.flechazo.oneenoughfluid.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class Utils {
    public static String getFluidRegistryName(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        ResourceLocation id = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        return id != null ? id.toString() : null;
    }

    public static Fluid getFluidById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        try {
            ResourceLocation rl = new ResourceLocation(id);
            return (Fluid)ForgeRegistries.FLUIDS.getValue(rl);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isTagExists(ResourceLocation tagId) {
        ITagManager mgr = ForgeRegistries.FLUIDS.tags();
        TagKey key = ForgeRegistries.FLUIDS.tags().createTagKey(tagId);
        return mgr != null && mgr.isKnownTagName(key);
    }

    public static Collection<Fluid> getFluidsOfTag(ResourceLocation tagId) {
        ITagManager mgr = ForgeRegistries.FLUIDS.tags();
        if (mgr == null) {
            return Collections.emptyList();
        }
        TagKey key = ForgeRegistries.FLUIDS.tags().createTagKey(tagId);
        ITag tag = mgr.getTag(key);
        return tag.stream().toList();
    }

    public static List<Fluid> resolveFluidList(List<String> identifiers) {
        ArrayList<Fluid> result = new ArrayList<Fluid>();
        for (String id : identifiers) {
            if (id == null || id.isEmpty()) continue;
            if (id.startsWith("#")) {
                ResourceLocation tag = new ResourceLocation(id.substring(1));
                result.addAll(Utils.getFluidsOfTag(tag));
                continue;
            }
            Fluid f = Utils.getFluidById(id);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }
}

