/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.util;

import net.dollar.apex.item.ModItems;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class ModItemProperties {
    public static void addCustomItemProperties() {
        ModItemProperties.makeBowItemProperties((Item)ModItems.COBALT_STEEL_BOW.get());
        ModItemProperties.makeBowItemProperties((Item)ModItems.INFUSED_GEMSTONE_BOW.get());
        ModItemProperties.makeBowItemProperties((Item)ModItems.TUNGSTEN_CARBIDE_BOW.get());
        ModItemProperties.makeCrossbowItemProperties((Item)ModItems.COBALT_STEEL_CROSSBOW.get());
        ModItemProperties.makeCrossbowItemProperties((Item)ModItems.INFUSED_GEMSTONE_CROSSBOW.get());
        ModItemProperties.makeCrossbowItemProperties((Item)ModItems.TUNGSTEN_CARBIDE_CROSSBOW.get());
    }

    private static void makeBowItemProperties(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (itemStack, level, userEntity, anInteger) -> {
            if (userEntity == null) {
                return 0.0f;
            }
            return userEntity.getUseItem() != itemStack ? 0.0f : (float)(itemStack.getUseDuration(userEntity) - userEntity.getUseItemRemainingTicks()) / 20.0f;
        });
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (itemStack, level, userEntity, anInteger) -> userEntity != null && userEntity.isUsingItem() && userEntity.getUseItem() == itemStack ? 1.0f : 0.0f);
    }

    private static void makeCrossbowItemProperties(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pull"), (itemStack, level, userEntity, anInteger) -> {
            if (userEntity == null) {
                return 0.0f;
            }
            return CrossbowItem.isCharged((ItemStack)itemStack) ? 0.0f : (float)(itemStack.getUseDuration(userEntity) - userEntity.getUseItemRemainingTicks()) / (float)CrossbowItem.getChargeDuration((ItemStack)itemStack, (LivingEntity)userEntity);
        });
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pulling"), (itemStack, level, userEntity, anInteger) -> userEntity != null && userEntity.isUsingItem() && userEntity.getUseItem() == itemStack && !CrossbowItem.isCharged((ItemStack)itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"charged"), (itemStack, level, userEntity, anInteger) -> CrossbowItem.isCharged((ItemStack)itemStack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"firework"), (itemStack, level, userEntity, anInteger) -> {
            ChargedProjectiles chargedprojectiles = (ChargedProjectiles)itemStack.get(DataComponents.CHARGED_PROJECTILES);
            return chargedprojectiles != null && chargedprojectiles.contains(Items.FIREWORK_ROCKET) ? 1.0f : 0.0f;
        });
    }
}

