/*
 * Decompiled with CFR 0.152.
 */
package net.dollar.apex.item.custom.equipment;

import java.util.List;
import net.dollar.apex.item.custom.ModPaxelItem;
import net.dollar.apex.util.ModItemUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ModCobaltSteelPaxelItem
extends ModPaxelItem {
    public ModCobaltSteelPaxelItem(ToolMaterial material, float attackDamage, float attackSpeed, Item.Properties properties) {
        super(material, attackDamage, attackSpeed, properties);
    }

    public float getDestroySpeed(@NotNull ItemStack itemStack, @NotNull BlockState state) {
        float baseVal = super.getDestroySpeed(itemStack, state);
        return state.getBlock() == Blocks.DEEPSLATE ? baseVal * 2.0f : baseVal;
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        ModItemUtils.applyCobaltSteelOnHit(target);
        return super.hurtEnemy(stack, target, attacker);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        ModItemUtils.appendCobaltSteelEquipmentTooltip(tooltip, ModItemUtils.EquipmentType.TOOL);
    }
}

